/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer;

import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.AbstractTablePage;
import org.activiti.explorer.ui.MainWindow;
import org.activiti.explorer.ui.management.db.DatabasePage;
import org.activiti.explorer.ui.management.deployment.DeploymentPage;
import org.activiti.explorer.ui.management.identity.GroupPage;
import org.activiti.explorer.ui.management.identity.UserPage;
import org.activiti.explorer.ui.management.job.JobPage;
import org.activiti.explorer.ui.process.MyProcessInstancesPage;
import org.activiti.explorer.ui.process.ProcessDefinitionPage;
import org.activiti.explorer.ui.profile.ProfilePopupWindow;
import org.activiti.explorer.ui.task.ArchivedPage;
import org.activiti.explorer.ui.task.InboxPage;
import org.activiti.explorer.ui.task.InvolvedPage;
import org.activiti.explorer.ui.task.QueuedPage;
import org.activiti.explorer.ui.task.TasksPage;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewManager
implements ViewManager {
    private static final long serialVersionUID = 1L;
    protected AbstractTablePage currentPage;
    @Autowired
    protected MainWindow mainWindow;
    protected TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected HistoryService historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
    protected IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();

    public void showLoginPage() {
        if (!this.mainWindow.isShowingLoginPage()) {
            this.mainWindow.showLoginPage();
        }
    }

    public void showDefaultPage() {
        this.mainWindow.showDefaultContent();
        this.showInboxPage();
    }

    public void showPopupWindow(Window window) {
        this.mainWindow.addWindow(window);
    }

    public void showTaskPage(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String loggedInUserId = ExplorerApp.get().getLoggedInUser().getId();
        if (task == null) {
            boolean isOwner;
            boolean bl = isOwner = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).taskOwner(loggedInUserId).count() == 1L;
            if (isOwner) {
                this.showArchivedPage(taskId);
            } else {
                this.showNavigationError(taskId);
            }
        } else if (loggedInUserId.equals(task.getOwner())) {
            this.showTasksPage(taskId);
        } else if (loggedInUserId.equals(task.getAssignee())) {
            this.showInboxPage(taskId);
        } else if (this.taskService.createTaskQuery().taskInvolvedUser(loggedInUserId).count() == 1L) {
            this.showInvolvedPage(taskId);
        } else {
            List groupIds = this.getGroupIds(loggedInUserId);
            List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
            Iterator identityLinkIterator = identityLinks.iterator();
            boolean pageFound = false;
            while (!pageFound && identityLinkIterator.hasNext()) {
                IdentityLink identityLink = (IdentityLink)identityLinkIterator.next();
                if (identityLink.getGroupId() == null || !groupIds.contains(identityLink.getGroupId())) continue;
                this.showQueuedPage(identityLink.getGroupId(), task.getId());
                pageFound = true;
            }
            if (!pageFound) {
                this.showNavigationError(taskId);
            }
        }
    }

    protected List<String> getGroupIds(String userId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected void showNavigationError(String taskId) {
        ExplorerApp.get().getNotificationManager().showErrorNotification("navigation.error.not.involved.title", ExplorerApp.get().getI18nManager().getMessage("navigation.error.not.involved", new Object[]{taskId}));
    }

    public void showTasksPage() {
        this.switchView((AbstractTablePage)new TasksPage(), "task", "tasks");
    }

    public void showTasksPage(String taskId) {
        this.switchView((AbstractTablePage)new TasksPage(taskId), "task", "tasks");
    }

    public void showInboxPage() {
        this.switchView((AbstractTablePage)new InboxPage(), "task", "inbox");
    }

    public void showInboxPage(String taskId) {
        this.switchView((AbstractTablePage)new InboxPage(taskId), "task", "inbox");
    }

    public void showQueuedPage(String groupId) {
        this.switchView((AbstractTablePage)new QueuedPage(groupId), "task", "queued");
    }

    public void showQueuedPage(String groupId, String taskId) {
        this.switchView((AbstractTablePage)new QueuedPage(groupId, taskId), "task", "queued");
    }

    public void showInvolvedPage() {
        this.switchView((AbstractTablePage)new InvolvedPage(), "task", "involved");
    }

    public void showInvolvedPage(String taskId) {
        this.switchView((AbstractTablePage)new InvolvedPage(taskId), "task", "involved");
    }

    public void showArchivedPage() {
        this.switchView((AbstractTablePage)new ArchivedPage(), "task", "archived");
    }

    public void showArchivedPage(String taskId) {
        this.switchView((AbstractTablePage)new ArchivedPage(taskId), "task", "archived");
    }

    public void showProcessDefinitionPage() {
        this.switchView((AbstractTablePage)new ProcessDefinitionPage(), "process", "processDefinitions");
    }

    public void showProcessDefinitionPage(String processDefinitionId) {
        this.switchView((AbstractTablePage)new ProcessDefinitionPage(processDefinitionId), "process", "processDefinitions");
    }

    public void showMyProcessInstancesPage() {
        this.switchView((AbstractTablePage)new MyProcessInstancesPage(), "process", "myProcessInstances");
    }

    public void showMyProcessInstancesPage(String processInstanceId) {
        this.switchView((AbstractTablePage)new MyProcessInstancesPage(processInstanceId), "process", "myProcessInstances");
    }

    public void showDatabasePage() {
        this.switchView((AbstractTablePage)new DatabasePage(), "manage", "database");
    }

    public void showDatabasePage(String tableName) {
        this.switchView((AbstractTablePage)new DatabasePage(tableName), "manage", "database");
    }

    public void showDeploymentPage() {
        this.switchView((AbstractTablePage)new DeploymentPage(), "manage", "deployments");
    }

    public void showDeploymentPage(String deploymentId) {
        this.switchView((AbstractTablePage)new DeploymentPage(deploymentId), "manage", "deployments");
    }

    public void showJobPage() {
        this.switchView((AbstractTablePage)new JobPage(), "manage", "jobs");
    }

    public void showJobPage(String jobId) {
        this.switchView((AbstractTablePage)new JobPage(jobId), "manage", "jobs");
    }

    public void showUserPage() {
        this.switchView((AbstractTablePage)new UserPage(), "manage", "users");
    }

    public void showUserPage(String userId) {
        this.switchView((AbstractTablePage)new UserPage(userId), "manage", "users");
    }

    public void showGroupPage() {
        this.switchView((AbstractTablePage)new GroupPage(), "manage", "groups");
    }

    public void showGroupPage(String groupId) {
        this.switchView((AbstractTablePage)new GroupPage(groupId), "manage", "groups");
    }

    public void showProcessInstancePage() {
        throw new UnsupportedOperationException();
    }

    public void showProcessInstancePage(String processInstanceId) {
        throw new UnsupportedOperationException();
    }

    public void showProfilePopup(String userId) {
        this.showPopupWindow((Window)new ProfilePopupWindow(userId));
    }

    protected void switchView(AbstractTablePage page, String mainMenuActive, String subMenuActive) {
        this.currentPage = page;
        this.mainWindow.setMainNavigation(mainMenuActive);
        this.mainWindow.switchView((Component)page);
        page.getToolBar().setActiveEntry(subMenuActive);
    }

    public AbstractTablePage getCurrentPage() {
        return this.currentPage;
    }

    public void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }
}

