/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer;

import com.vaadin.Application;
import com.vaadin.terminal.gwt.server.HttpServletRequestListener;
import com.vaadin.ui.Window;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.util.LogUtil;
import org.activiti.explorer.ComponentFactories;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.cache.UserCache;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.ComponentFactory;
import org.activiti.explorer.ui.MainWindow;
import org.activiti.explorer.ui.content.AttachmentRendererManager;
import org.activiti.explorer.ui.form.FormPropertyRendererManager;
import org.activiti.explorer.ui.login.LoginHandler;
import org.activiti.explorer.ui.variable.VariableRendererManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerApp
extends Application
implements HttpServletRequestListener {
    private static final long serialVersionUID = -1L;
    protected static ThreadLocal<ExplorerApp> current;
    protected String environment;
    protected UserCache userCache;
    protected MainWindow mainWindow;
    protected ViewManager viewManager;
    protected NotificationManager notificationManager;
    protected I18nManager i18nManager;
    protected AttachmentRendererManager attachmentRendererManager;
    protected FormPropertyRendererManager formPropertyRendererManager;
    protected VariableRendererManager variableRendererManager;
    protected LoginHandler loginHandler;
    protected ComponentFactories componentFactories;
    protected boolean invalidatedSession = false;

    public void init() {
        this.setMainWindow((Window)this.mainWindow);
        this.mainWindow.showLoginPage();
    }

    public void close() {
        LoggedInUser theUser = this.getLoggedInUser();
        this.setUser(null);
        this.getLoginHandler().logout(theUser);
        this.invalidatedSession = false;
        super.close();
    }

    public static ExplorerApp get() {
        return (ExplorerApp)current.get();
    }

    public LoggedInUser getLoggedInUser() {
        return (LoggedInUser)this.getUser();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public I18nManager getI18nManager() {
        return this.i18nManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public AttachmentRendererManager getAttachmentRendererManager() {
        return this.attachmentRendererManager;
    }

    public FormPropertyRendererManager getFormPropertyRendererManager() {
        return this.formPropertyRendererManager;
    }

    public void setFormPropertyRendererManager(FormPropertyRendererManager formPropertyRendererManager) {
        this.formPropertyRendererManager = formPropertyRendererManager;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public <T> ComponentFactory<T> getComponentFactory(Class<? extends ComponentFactory<T>> clazz) {
        return this.componentFactories.get(clazz);
    }

    public LoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public void setVariableRendererManager(VariableRendererManager variableRendererManager) {
        this.variableRendererManager = variableRendererManager;
    }

    public VariableRendererManager getVariableRendererManager() {
        return this.variableRendererManager;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.i18nManager != null) {
            this.i18nManager.createResourceBundle();
        }
    }

    public void onRequestStart(HttpServletRequest request, HttpServletResponse response) {
        current.set(this);
        LoggedInUser user = (LoggedInUser)this.getUser();
        if (user == null) {
            user = this.loginHandler.authenticate(request, response);
            if (user == null) {
                if (this.mainWindow != null && !this.mainWindow.isShowingLoginPage()) {
                    this.viewManager.showLoginPage();
                }
            } else {
                this.setUser((Object)user);
            }
        }
        if (user != null) {
            Authentication.setAuthenticatedUserId((String)user.getId());
            if (this.mainWindow != null && this.mainWindow.isShowingLoginPage()) {
                this.viewManager.showDefaultPage();
            }
        }
        this.loginHandler.onRequestStart(request, response);
    }

    public void onRequestEnd(HttpServletRequest request, HttpServletResponse response) {
        current.remove();
        Authentication.setAuthenticatedUserId(null);
        this.loginHandler.onRequestEnd(request, response);
        if (!this.isRunning() && !this.invalidatedSession && request.getSession(false) != null) {
            request.getSession().invalidate();
            this.invalidatedSession = true;
        }
    }

    public void setCurrentUriFragment(UriFragment fragment) {
        this.mainWindow.setCurrentUriFragment(fragment);
    }

    public UriFragment getCurrentUriFragment() {
        return this.mainWindow.getCurrentUriFragment();
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public void setApplicationMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void setViewManager(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setI18nManager(I18nManager i18nManager) {
        this.i18nManager = i18nManager;
    }

    public void setAttachmentRendererManager(AttachmentRendererManager attachmentRendererManager) {
        this.attachmentRendererManager = attachmentRendererManager;
    }

    public void setComponentFactories(ComponentFactories componentFactories) {
        this.componentFactories = componentFactories;
    }

    public void setLoginHandler(LoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    static {
        LogUtil.readJavaUtilLoggingConfigFromClasspath();
        current = new ThreadLocal();
    }
}

