/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.cache;

import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.LinkedList;
import org.activiti.explorer.cache.DuplicateKeyException;
import org.activiti.explorer.cache.RadixTree;
import org.activiti.explorer.cache.RadixTreeImpl;
import org.activiti.explorer.cache.RadixTreeNode;
import org.activiti.explorer.cache.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadixTreeImpl<T>
implements RadixTree<T>,
Formattable {
    protected RadixTreeNode<T> root = new RadixTreeNode();
    protected long size;

    public RadixTreeImpl() {
        this.root.setKey("");
        this.size = 0L;
    }

    public T find(String key) {
        1 visitor = new /* Unavailable Anonymous Inner Class!! */;
        this.visit(key, (Visitor)visitor);
        return (T)visitor.getResult();
    }

    public boolean delete(String key) {
        2 visitor = new /* Unavailable Anonymous Inner Class!! */;
        this.visit(key, (Visitor)visitor);
        if (((Boolean)visitor.getResult()).booleanValue()) {
            --this.size;
        }
        return (Boolean)visitor.getResult();
    }

    public void insert(String key, T value) throws DuplicateKeyException {
        try {
            this.insert(key, this.root, value);
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateKeyException("Duplicate key: '" + key + "'");
        }
        ++this.size;
    }

    private void insert(String key, RadixTreeNode<T> node, T value) throws DuplicateKeyException {
        int numberOfMatchingCharacters = node.getNumberOfMatchingCharacters(key);
        if (node.getKey().equals("") || numberOfMatchingCharacters == 0 || numberOfMatchingCharacters < key.length() && numberOfMatchingCharacters >= node.getKey().length()) {
            boolean flag = false;
            String newText = key.substring(numberOfMatchingCharacters, key.length());
            for (RadixTreeNode child : node.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                flag = true;
                this.insert(newText, child, value);
                break;
            }
            if (!flag) {
                RadixTreeNode n = new RadixTreeNode();
                n.setKey(newText);
                n.setReal(true);
                n.setValue(value);
                node.getChildern().add(n);
            }
        } else if (numberOfMatchingCharacters == key.length() && numberOfMatchingCharacters == node.getKey().length()) {
            if (node.isReal()) {
                throw new DuplicateKeyException("Duplicate key");
            }
            node.setReal(true);
            node.setValue(value);
        } else if (numberOfMatchingCharacters > 0 && numberOfMatchingCharacters < node.getKey().length()) {
            RadixTreeNode n1 = new RadixTreeNode();
            n1.setKey(node.getKey().substring(numberOfMatchingCharacters, node.getKey().length()));
            n1.setReal(node.isReal());
            n1.setValue(node.getValue());
            n1.setChildern(node.getChildern());
            node.setKey(key.substring(0, numberOfMatchingCharacters));
            node.setReal(false);
            node.setChildern(new ArrayList());
            node.getChildern().add(n1);
            if (numberOfMatchingCharacters < key.length()) {
                RadixTreeNode n2 = new RadixTreeNode();
                n2.setKey(key.substring(numberOfMatchingCharacters, key.length()));
                n2.setReal(true);
                n2.setValue(value);
                node.getChildern().add(n2);
            } else {
                node.setValue(value);
                node.setReal(true);
            }
        } else {
            RadixTreeNode n = new RadixTreeNode();
            n.setKey(node.getKey().substring(numberOfMatchingCharacters, node.getKey().length()));
            n.setChildern(node.getChildern());
            n.setReal(node.isReal());
            n.setValue(node.getValue());
            node.setKey(key);
            node.setReal(true);
            node.setValue(value);
            node.getChildern().add(n);
        }
    }

    public ArrayList<T> searchPrefix(String key, int recordLimit) {
        ArrayList<Object> keys = new ArrayList<Object>();
        RadixTreeNode node = this.searchPefix(key, this.root);
        if (node != null) {
            if (node.isReal()) {
                keys.add(node.getValue());
            }
            this.getNodes(node, keys, recordLimit);
        }
        return keys;
    }

    private void getNodes(RadixTreeNode<T> parent, ArrayList<T> keys, int limit) {
        LinkedList queue = new LinkedList();
        queue.addAll(parent.getChildern());
        while (!queue.isEmpty()) {
            RadixTreeNode node = (RadixTreeNode)queue.remove();
            if (node.isReal()) {
                keys.add(node.getValue());
            }
            if (keys.size() == limit) break;
            queue.addAll(node.getChildern());
        }
    }

    private RadixTreeNode<T> searchPefix(String key, RadixTreeNode<T> node) {
        RadixTreeNode result = null;
        int numberOfMatchingCharacters = node.getNumberOfMatchingCharacters(key);
        if (numberOfMatchingCharacters == key.length() && numberOfMatchingCharacters <= node.getKey().length()) {
            result = node;
        } else if (node.getKey().equals("") || numberOfMatchingCharacters < key.length() && numberOfMatchingCharacters >= node.getKey().length()) {
            String newText = key.substring(numberOfMatchingCharacters, key.length());
            for (RadixTreeNode child : node.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                result = this.searchPefix(newText, child);
                break;
            }
        }
        return result;
    }

    public boolean contains(String key) {
        3 visitor = new /* Unavailable Anonymous Inner Class!! */;
        this.visit(key, (Visitor)visitor);
        return (Boolean)visitor.getResult();
    }

    public <R> void visit(String key, Visitor<T, R> visitor) {
        if (this.root != null) {
            this.visit(key, visitor, null, this.root);
        }
    }

    private <R> void visit(String prefix, Visitor<T, R> visitor, RadixTreeNode<T> parent, RadixTreeNode<T> node) {
        int numberOfMatchingCharacters = node.getNumberOfMatchingCharacters(prefix);
        if (numberOfMatchingCharacters == prefix.length() && numberOfMatchingCharacters == node.getKey().length()) {
            visitor.visit(prefix, parent, node);
        } else if (node.getKey().equals("") || numberOfMatchingCharacters < prefix.length() && numberOfMatchingCharacters >= node.getKey().length()) {
            String newText = prefix.substring(numberOfMatchingCharacters, prefix.length());
            for (RadixTreeNode child : node.getChildern()) {
                if (!child.getKey().startsWith(newText.charAt(0) + "")) continue;
                this.visit(newText, visitor, node, child);
                break;
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    @Deprecated
    public void display() {
        this.formatNodeTo(new Formatter(System.out), 0, this.root);
    }

    @Deprecated
    private void display(int level, RadixTreeNode<T> node) {
        this.formatNodeTo(new Formatter(System.out), level, node);
    }

    private void formatNodeTo(Formatter f, int level, RadixTreeNode<T> node) {
        int i;
        for (i = 0; i < level; ++i) {
            f.format(" ", new Object[0]);
        }
        f.format("|", new Object[0]);
        for (i = 0; i < level; ++i) {
            f.format("-", new Object[0]);
        }
        if (node.isReal()) {
            f.format("%s[%s]*%n", node.getKey(), node.getValue());
        } else {
            f.format("%s%n", node.getKey());
        }
        for (RadixTreeNode child : node.getChildern()) {
            this.formatNodeTo(f, level + 1, child);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        this.formatNodeTo(formatter, 0, this.root);
    }

    public String complete(String prefix) {
        return this.complete(prefix, this.root, "");
    }

    private String complete(String key, RadixTreeNode<T> node, String base) {
        int i;
        int keylen = key.length();
        int nodelen = node.getKey().length();
        for (i = 0; i < keylen && i < nodelen && key.charAt(i) == node.getKey().charAt(i); ++i) {
        }
        if (i == keylen && i <= nodelen) {
            return base + node.getKey();
        }
        if (nodelen == 0 || i < keylen && i >= nodelen) {
            String beginning = key.substring(0, i);
            String ending = key.substring(i, keylen);
            for (RadixTreeNode child : node.getChildern()) {
                if (!child.getKey().startsWith(ending.charAt(0) + "")) continue;
                return this.complete(ending, child, base + beginning);
            }
        }
        return "";
    }
}

