/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.explorer.cache.RadixTree;
import org.activiti.explorer.cache.RadixTreeImpl;
import org.activiti.explorer.cache.UserCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class TrieBasedUserCache
implements UserCache {
    private static final Logger LOGGER = Logger.getLogger(TrieBasedUserCache.class.getName());
    protected IdentityService identityService;
    protected RadixTree<List<User>> userTrie = new RadixTreeImpl();
    protected Map<String, List<String>> keyCache = new HashMap();
    protected Map<String, User> userCache = new HashMap();

    public void refresh() {
        this.userTrie = new RadixTreeImpl();
        this.loadUsers();
    }

    public synchronized void loadUsers() {
        long nrOfUsers = this.identityService.createUserQuery().count();
        long usersAdded = 0L;
        this.userTrie = new RadixTreeImpl();
        this.userCache = new HashMap();
        this.keyCache = new HashMap();
        while (usersAdded < nrOfUsers) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Caching users " + usersAdded + " to " + (usersAdded + 25L));
            }
            List users = this.identityService.createUserQuery().listPage((int)usersAdded, 25);
            for (User user : users) {
                this.addTrieItem(user);
                this.addUserCacheItem(user);
                ++usersAdded;
            }
        }
    }

    protected void addTrieItem(User user) {
        for (String key : this.getKeys(user)) {
            this.addTrieCacheItem(key, user);
        }
    }

    protected String[] getKeys(User user) {
        String fullname = "";
        if (user.getFirstName() != null) {
            fullname = fullname + user.getFirstName();
        }
        if (user.getLastName() != null) {
            fullname = fullname + " " + user.getLastName();
        }
        return fullname.split(" ");
    }

    protected void addTrieCacheItem(String key, User user) {
        key = key.toLowerCase();
        List<Object> value = null;
        value = !this.userTrie.contains(key) ? new ArrayList<User>() : (List)this.userTrie.find(key);
        value.add(user);
        this.userTrie.delete(key);
        this.userTrie.insert(key, value);
        if (!this.keyCache.containsKey(user.getId())) {
            this.keyCache.put(user.getId(), new ArrayList());
        }
        ((List)this.keyCache.get(user.getId())).add(key);
    }

    protected void addUserCacheItem(User user) {
        this.userCache.put(user.getId(), user);
    }

    public User findUser(String userId) {
        if (this.userCache.isEmpty()) {
            this.loadUsers();
        }
        return (User)this.userCache.get(userId);
    }

    public List<User> findMatchingUsers(String prefix) {
        if (this.userTrie.getSize() == 0L) {
            this.refresh();
        }
        ArrayList<User> returnValue = new ArrayList<User>();
        ArrayList results = this.userTrie.searchPrefix(prefix.toLowerCase(), 100);
        for (List result : results) {
            for (User userDetail : result) {
                returnValue.add(userDetail);
            }
        }
        return returnValue;
    }

    public void notifyUserDataChanged(String userId) {
        User newData = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (this.keyCache.containsKey(userId)) {
            for (String key : (List)this.keyCache.get(userId)) {
                List users = (List)this.userTrie.find(key);
                if (users == null || users.isEmpty()) continue;
                Iterator userIterator = users.iterator();
                while (userIterator.hasNext()) {
                    User next = (User)userIterator.next();
                    if (!next.getId().equals(userId)) continue;
                    userIterator.remove();
                }
            }
        }
        this.keyCache.remove(userId);
        if (newData != null) {
            this.addTrieItem(newData);
            this.userCache.put(newData.getId(), newData);
        }
    }

    @Autowired
    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        this.loadUsers();
    }
}

