/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.demo;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoDataGenerator {
    protected static final Logger LOGGER = Logger.getLogger(DemoDataGenerator.class.getName());
    protected ProcessEngine processEngine;
    protected IdentityService identityService;

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.identityService = processEngine.getIdentityService();
        this.initDemoGroups();
        this.initDemoUsers();
    }

    protected void initDemoGroups() {
        String[] securityGroups;
        String[] assignmentGroups;
        for (String groupId : assignmentGroups = new String[]{"management", "sales", "marketing", "engineering"}) {
            this.createGroup(groupId, "assignment");
        }
        for (String groupId : securityGroups = new String[]{"user", "admin"}) {
            this.createGroup(groupId, "security-role");
        }
    }

    protected void createGroup(String groupId, String type) {
        if (this.identityService.createGroupQuery().groupId(groupId).count() == 0L) {
            Group newGroup = this.identityService.newGroup(groupId);
            newGroup.setName(groupId.substring(0, 1).toUpperCase() + groupId.substring(1));
            newGroup.setType(type);
            this.identityService.saveGroup(newGroup);
        }
    }

    protected void initDemoUsers() {
        this.createUser("kermit", "Kermit", "The Frog", "kermit", "kermit@activiti.org", "org/activiti/explorer/images/kermit.jpg", Arrays.asList("management", "sales", "marketing", "engineering", "user", "admin"), Arrays.asList("birthDate", "10-10-1955", "jobTitle", "Muppet", "location", "Hollywoord", "phone", "+123456789", "twitterName", "alfresco", "skype", "activiti_kermit_frog"));
        this.createUser("gonzo", "Gonzo", "The Great", "gonzo", "gonzo@activiti.org", "org/activiti/explorer/images/gonzo.jpg", Arrays.asList("management", "sales", "marketing", "user"), null);
        this.createUser("fozzie", "Fozzie", "Bear", "fozzie", "fozzie@activiti.org", "org/activiti/explorer/images/fozzie.jpg", Arrays.asList("marketing", "engineering", "user"), null);
    }

    protected void createUser(String userId, String firstName, String lastName, String password, String email, String imageResource, List<String> groups, List<String> userInfo) {
        if (this.identityService.createUserQuery().userId(userId).count() == 0L) {
            User user = this.identityService.newUser(userId);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setPassword(password);
            user.setEmail(email);
            this.identityService.saveUser(user);
            if (groups != null) {
                for (String group : groups) {
                    this.identityService.createMembership(userId, group);
                }
            }
        }
        if (imageResource != null) {
            byte[] pictureBytes = IoUtil.readInputStream((InputStream)this.getClass().getClassLoader().getResourceAsStream(imageResource), null);
            Picture picture = new Picture(pictureBytes, "image/jpeg");
            this.identityService.setUserPicture(userId, picture);
        }
        if (userInfo != null) {
            for (int i = 0; i < userInfo.size(); i += 2) {
                this.identityService.setUserInfo(userId, userInfo.get(i), userInfo.get(i + 1));
            }
        }
    }

    protected void initProcessDefinitions() {
        this.processEngine.getRepositoryService().createDeployment().name("Demo processes").addClasspathResource("org/activiti/explorer/demo/process/testProcess.bpmn20.xml").addClasspathResource("org/activiti/explorer/demo/process/oneTaskProcess.bpmn20.xml").addClasspathResource("org/activiti/explorer/demo/process/createTimersProcess.bpmn20.xml").deploy();
    }
}

