/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.navigation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.navigation.DatabaseNavigator;
import org.activiti.explorer.navigation.DeploymentNavigator;
import org.activiti.explorer.navigation.GroupNavigator;
import org.activiti.explorer.navigation.JobNavigator;
import org.activiti.explorer.navigation.MyProcessesNavigator;
import org.activiti.explorer.navigation.Navigator;
import org.activiti.explorer.navigation.ProcessNavigator;
import org.activiti.explorer.navigation.TaskNavigator;
import org.activiti.explorer.navigation.UserNavigator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class NavigatorManager
implements InitializingBean,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Navigator> navigationHandlers = new HashMap();
    protected Navigator defaultHandler;

    public void addNavigator(Navigator handler) {
        this.navigationHandlers.put(handler.getTrigger(), handler);
    }

    public Navigator getNavigator(String trigger) {
        if (trigger != null) {
            return (Navigator)this.navigationHandlers.get(trigger);
        }
        return null;
    }

    public Navigator getDefaultNavigator() {
        if (this.defaultHandler == null) {
            throw new IllegalStateException("No default navigation handler has been set");
        }
        return this.defaultHandler;
    }

    public void setDefaultNavigator(Navigator handler) {
        this.defaultHandler = handler;
    }

    public void afterPropertiesSet() throws Exception {
        this.addNavigator((Navigator)new TaskNavigator());
        this.addNavigator((Navigator)new ProcessNavigator());
        this.addNavigator((Navigator)new DeploymentNavigator());
        this.addNavigator((Navigator)new DatabaseNavigator());
        this.addNavigator((Navigator)new JobNavigator());
        this.addNavigator((Navigator)new UserNavigator());
        this.addNavigator((Navigator)new GroupNavigator());
        this.addNavigator((Navigator)new MyProcessesNavigator());
    }
}

