/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.alfresco;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.alfresco.AlfrescoProcessInstanceTableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceTableLazyQuery
extends AbstractLazyLoadingQuery {
    protected RuntimeService runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
    protected String processDefinitionId;

    public ProcessInstanceTableLazyQuery() {
    }

    public ProcessInstanceTableLazyQuery(String processDefinitionId) {
        this();
        this.processDefinitionId = processDefinitionId;
    }

    public int size() {
        return (int)this.constructQuery().count();
    }

    public Item loadSingleResult(String id) {
        return new AlfrescoProcessInstanceTableItem((ProcessInstance)this.constructQuery().processInstanceId(id).singleResult());
    }

    public List<Item> loadItems(int start, int count) {
        List processInstances = this.constructQuery().listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>(processInstances.size());
        for (ProcessInstance processInstance : processInstances) {
            items.add((Item)new AlfrescoProcessInstanceTableItem(processInstance));
        }
        return items;
    }

    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    protected ProcessInstanceQuery constructQuery() {
        ProcessInstanceQuery query = (ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().asc();
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        return query;
    }

    public void setProcessDefintionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }
}

