/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.content.AttachmentEditor;
import org.activiti.explorer.ui.content.AttachmentEditorComponent;
import org.activiti.explorer.ui.content.AttachmentRendererManager;
import org.activiti.explorer.ui.custom.PopupWindow;
import org.activiti.explorer.ui.event.SubmitEvent;

public class CreateAttachmentPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected AttachmentRendererManager attachmentRendererManager = ExplorerApp.get().getAttachmentRendererManager();
    protected TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected HorizontalLayout layout;
    protected GridLayout detailLayout;
    protected AttachmentEditorComponent currentEditor;
    protected Table attachmentTypes;
    protected Button okButton;

    public CreateAttachmentPopupWindow() {
        this.setCaption(this.i18nManager.getMessage("related.content.add"));
        this.setWidth(700.0f, 0);
        this.setHeight(430.0f, 0);
        this.center();
        this.setModal(true);
        this.addStyleName("light");
        this.layout = new HorizontalLayout();
        this.layout.setSpacing(false);
        this.layout.setMargin(true);
        this.layout.setSizeFull();
        this.setContent((ComponentContainer)this.layout);
        this.initTable();
        this.detailLayout = new GridLayout(1, 2);
        this.detailLayout.setSizeFull();
        this.detailLayout.setMargin(true);
        this.detailLayout.setSpacing(true);
        this.detailLayout.addStyleName("related-content-create-detail");
        this.layout.addComponent((Component)this.detailLayout);
        this.layout.setExpandRatio((Component)this.detailLayout, 1.0f);
        this.detailLayout.setRowExpandRatio(0, 1.0f);
        this.detailLayout.setColumnExpandRatio(0, 1.0f);
        this.initActions();
    }

    public void attach() {
        super.attach();
        if (this.attachmentTypes.size() > 0) {
            this.attachmentTypes.select(this.attachmentTypes.firstItemId());
        }
    }

    protected void initActions() {
        this.okButton = new Button(this.i18nManager.getMessage("related.content.create"));
        this.detailLayout.addComponent((Component)this.okButton, 0, 1);
        this.okButton.setEnabled(false);
        this.okButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.detailLayout.setComponentAlignment((Component)this.okButton, Alignment.BOTTOM_RIGHT);
    }

    protected void initTable() {
        this.attachmentTypes = new Table();
        this.attachmentTypes.setSizeUndefined();
        this.attachmentTypes.setColumnHeaderMode(-1);
        this.attachmentTypes.setSelectable(true);
        this.attachmentTypes.setImmediate(true);
        this.attachmentTypes.setNullSelectionAllowed(false);
        this.attachmentTypes.setWidth(200.0f, 0);
        this.attachmentTypes.setHeight(100.0f, 8);
        this.attachmentTypes.setCellStyleGenerator((Table.CellStyleGenerator)new /* Unavailable Anonymous Inner Class!! */);
        this.attachmentTypes.addStyleName("related-content-create-list");
        this.attachmentTypes.addContainerProperty((Object)"type", Embedded.class, null);
        this.attachmentTypes.setColumnWidth((Object)"type", 16);
        this.attachmentTypes.addContainerProperty((Object)"name", String.class, null);
        for (AttachmentEditor editor : this.attachmentRendererManager.getAttachmentEditors()) {
            String name = editor.getTitle(this.i18nManager);
            Embedded image = null;
            Resource resource = editor.getImage();
            if (resource != null) {
                image = new Embedded(null, resource);
            }
            Item item = this.attachmentTypes.addItem((Object)editor.getName());
            item.getItemProperty((Object)"type").setValue((Object)image);
            item.getItemProperty((Object)"name").setValue((Object)name);
        }
        this.attachmentTypes.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.addComponent((Component)this.attachmentTypes);
    }

    protected void selectType(String type) {
        if (type != null) {
            this.setCurrentEditor(this.attachmentRendererManager.getEditor(type));
        } else {
            this.setCurrentEditor(null);
        }
    }

    protected void setCurrentEditor(AttachmentEditor editor) {
        AttachmentEditorComponent component;
        this.currentEditor = component = editor.getEditor(null, this.taskId, this.processInstanceId);
        this.detailLayout.removeComponent(this.detailLayout.getComponent(0, 0));
        if (this.currentEditor != null) {
            this.currentEditor.setSizeFull();
            this.detailLayout.addComponent((Component)this.currentEditor, 0, 0);
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void saveAttachment() {
        try {
            Attachment attachment = this.currentEditor.getAttachment();
            this.fireEvent((Component.Event)new SubmitEvent((Component)this, "submit", (Object)attachment));
            this.close();
        }
        catch (Validator.InvalidValueException invalidValueException) {
            // empty catch block
        }
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }
}

