/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content.file;

import com.vaadin.data.Validator;
import com.vaadin.terminal.ErrorMessage;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.content.AttachmentEditorComponent;
import org.activiti.explorer.ui.custom.UploadComponent;

public class FileAttachmentEditorComponent
extends VerticalLayout
implements AttachmentEditorComponent {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE_EXTENTION_SPLIT_CHAR = ";";
    protected Attachment attachment;
    protected String taskId;
    protected String processInstanceId;
    protected String fileName;
    protected ByteArrayOutputStream byteArrayOutputStream;
    protected String mimeType;
    protected boolean fileUploaded = false;
    protected I18nManager i18nManager;
    protected TaskService taskService;
    protected Form form;
    protected UploadComponent uploadComponent;
    protected Label successIndicator;

    public FileAttachmentEditorComponent(String taskId, String processInstanceId) {
        this(null, taskId, processInstanceId);
    }

    public FileAttachmentEditorComponent(Attachment attachment, String taskId, String processInstanceId) {
        this.attachment = attachment;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.form = new Form();
        this.form.setDescription(this.i18nManager.getMessage("related.content.type.file.help"));
        this.setSizeFull();
        this.addComponent((Component)this.form);
        this.initSuccessIndicator();
        this.initFileUpload();
        this.initName();
        this.initDescription();
    }

    protected void initSuccessIndicator() {
        this.successIndicator = new Label();
        this.successIndicator.setIcon(Images.SUCCESS);
        this.successIndicator.setVisible(false);
        this.addComponent((Component)this.successIndicator);
    }

    protected void initFileUpload() {
        this.uploadComponent = new UploadComponent(null, (Upload.Receiver)new /* Unavailable Anonymous Inner Class!! */);
        this.uploadComponent.addFinishedListener((Upload.FinishedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addComponent((Component)this.uploadComponent);
        this.setExpandRatio((Component)this.uploadComponent, 1.0f);
    }

    protected String extractExtention(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex > 0 && lastIndex < fileName.length() - 1) {
            return fileName.substring(lastIndex + 1);
        }
        return null;
    }

    protected String getFriendlyName(String name) {
        if (name != null) {
            String friendlyName = null;
            int lastDotIndex = name.lastIndexOf(".");
            friendlyName = lastDotIndex > 0 ? name.substring(0, name.length() - (name.length() - lastDotIndex)) : name;
            return friendlyName.replace("_", " ").replace("-", " ");
        }
        return name;
    }

    protected void initDescription() {
        TextArea descriptionField = new TextArea(this.i18nManager.getMessage("related.content.description"));
        descriptionField.setWidth(100.0f, 8);
        descriptionField.setHeight(50.0f, 0);
        this.form.addField((Object)"description", (Field)descriptionField);
    }

    protected void initName() {
        TextField nameField = new TextField(this.i18nManager.getMessage("related.content.name"));
        nameField.focus();
        nameField.setRequired(true);
        nameField.setRequiredError(this.i18nManager.getMessage("related.content.name.required"));
        nameField.setWidth(100.0f, 8);
        this.form.addField((Object)"name", (Field)nameField);
    }

    public Attachment getAttachment() throws Validator.InvalidValueException {
        this.form.commit();
        if (!this.fileUploaded) {
            Validator.InvalidValueException ive = new Validator.InvalidValueException(this.i18nManager.getMessage("related.content.type.file.required"));
            this.form.setComponentError((ErrorMessage)ive);
            throw ive;
        }
        if (this.attachment != null) {
            this.applyValuesToAttachment();
        } else {
            this.attachment = this.taskService.createAttachment(this.mimeType, this.taskId, this.processInstanceId, this.getAttachmentName(), this.getAttachmentDescription(), (InputStream)new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray()));
        }
        return this.attachment;
    }

    protected void setAttachmentName(String name) {
        this.form.getField((Object)"name").setValue((Object)name);
    }

    protected String getAttachmentName() {
        return (String)this.form.getField((Object)"name").getValue();
    }

    protected String getAttachmentDescription() {
        return (String)this.form.getField((Object)"description").getValue();
    }

    private void applyValuesToAttachment() {
        this.attachment.setName(this.getAttachmentName());
        this.attachment.setDescription(this.getAttachmentDescription());
    }
}

