/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content.file;

import com.vaadin.Application;
import com.vaadin.terminal.ExternalResource;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import java.io.InputStream;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.content.GenericAttachmentRenderer;
import org.activiti.explorer.ui.util.InputStreamStreamSource;
import org.activiti.explorer.util.ImageUtil;

public class ImageAttachmentRenderer
extends GenericAttachmentRenderer {
    public boolean canRenderAttachment(String type) {
        return type != null && type.startsWith("image/");
    }

    public Resource getImage(Attachment attachment) {
        return Images.RELATED_CONTENT_PICTURE;
    }

    public Component getDetailComponent(Attachment attachment) {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setSizeUndefined();
        verticalLayout.setSpacing(true);
        verticalLayout.setMargin(true);
        Label description = new Label(attachment.getDescription());
        description.setSizeUndefined();
        verticalLayout.addComponent((Component)description);
        TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        String mimeType = this.extractMineType(attachment.getType());
        InputStream imageStream = ImageUtil.smallify((InputStream)taskService.getAttachmentContent(attachment.getId()), (String)mimeType, (int)900, (int)550);
        StreamResource resource = new StreamResource((StreamResource.StreamSource)new InputStreamStreamSource(imageStream), attachment.getName() + this.extractExtention(attachment.getType()), (Application)ExplorerApp.get());
        Embedded image = new Embedded(null, (Resource)resource);
        verticalLayout.addComponent((Component)image);
        HorizontalLayout LinkLayout = new HorizontalLayout();
        LinkLayout.setSpacing(true);
        verticalLayout.addComponent((Component)LinkLayout);
        verticalLayout.setComponentAlignment((Component)LinkLayout, Alignment.MIDDLE_CENTER);
        Label fullSizeLabel = new Label(ExplorerApp.get().getI18nManager().getMessage("related.content.show.full.size"));
        LinkLayout.addComponent((Component)fullSizeLabel);
        Link link = null;
        if (attachment.getUrl() != null) {
            link = new Link(attachment.getUrl(), (Resource)new ExternalResource(attachment.getUrl()));
        } else {
            taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
            StreamResource res = new StreamResource((StreamResource.StreamSource)new InputStreamStreamSource(taskService.getAttachmentContent(attachment.getId())), attachment.getName() + this.extractExtention(attachment.getType()), (Application)ExplorerApp.get());
            link = new Link(attachment.getName(), (Resource)res);
        }
        link.setIcon(Images.RELATED_CONTENT_PICTURE);
        link.setTargetName("_blank");
        LinkLayout.addComponent((Component)link);
        return verticalLayout;
    }

    protected String extractMineType(String type) {
        int index;
        if (type != null && (index = type.lastIndexOf(";")) >= 0) {
            return type.substring(0, index);
        }
        return type;
    }
}

