/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content.url;

import com.vaadin.data.Validator;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.content.AttachmentEditorComponent;

public class UrlAttachmentEditorComponent
extends Form
implements AttachmentEditorComponent {
    private static final long serialVersionUID = 1L;
    protected Attachment attachment;
    protected String taskId;
    protected String processInstanceId;
    protected I18nManager i18nManager;
    protected TaskService taskService;

    public UrlAttachmentEditorComponent(String taskId, String processInstanceId) {
        this(null, taskId, processInstanceId);
    }

    public UrlAttachmentEditorComponent(Attachment attachment, String taskId, String processInstanceId) {
        this.attachment = attachment;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.setSizeFull();
        this.setDescription(this.i18nManager.getMessage("related.content.type.url.help"));
        this.initUrl();
        this.initName();
        this.initDescription();
    }

    protected void initUrl() {
        TextField urlField = new TextField(this.i18nManager.getMessage("related.content.type.url.url"));
        urlField.focus();
        urlField.setRequired(true);
        urlField.setRequiredError(this.i18nManager.getMessage("related.content.type.url.url.required"));
        urlField.setWidth(100.0f, 8);
        if (this.attachment != null) {
            urlField.setEnabled(false);
        }
        this.addField((Object)"url", (Field)urlField);
    }

    protected void initDescription() {
        TextArea descriptionField = new TextArea(this.i18nManager.getMessage("related.content.description"));
        descriptionField.setWidth(100.0f, 8);
        descriptionField.setHeight(100.0f, 0);
        this.addField((Object)"description", (Field)descriptionField);
    }

    protected void initName() {
        TextField nameField = new TextField(this.i18nManager.getMessage("related.content.name"));
        nameField.setWidth(100.0f, 8);
        this.addField((Object)"name", (Field)nameField);
    }

    public Attachment getAttachment() throws Validator.InvalidValueException {
        this.commit();
        if (this.attachment != null) {
            this.applyValuesToAttachment();
        } else {
            this.attachment = this.taskService.createAttachment("url", this.taskId, this.processInstanceId, this.getAttachmentName(), this.getAttachmentDescription(), this.getAttachmentUrl());
        }
        return this.attachment;
    }

    protected String getAttachmentUrl() {
        return this.getFieldValue("url");
    }

    protected String getAttachmentName() {
        String name = this.getFieldValue("name");
        if (name == null) {
            name = this.getAttachmentUrl();
        }
        return name;
    }

    protected String getAttachmentDescription() {
        return this.getFieldValue("description");
    }

    protected String getFieldValue(String key) {
        String value = (String)this.getField((Object)key).getValue();
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    private void applyValuesToAttachment() {
        this.attachment.setName(this.getAttachmentName());
        this.attachment.setDescription(this.getAttachmentDescription());
    }
}

