/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.content.url;

import com.vaadin.terminal.ExternalResource;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.task.Attachment;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.content.AttachmentRenderer;
import org.activiti.explorer.ui.content.RelatedContentComponent;

public class UrlAttachmentRenderer
implements AttachmentRenderer {
    public static final String ATTACHMENT_TYPE = "url";

    public String getName(I18nManager i18nManager) {
        return i18nManager.getMessage("related.content.type.url");
    }

    public Resource getImage(Attachment attachment) {
        return Images.RELATED_CONTENT_URL;
    }

    public Component getOverviewComponent(Attachment attachment, RelatedContentComponent parent) {
        if (attachment.getDescription() != null && !"".equals(attachment.getDescription())) {
            Button attachmentLink = new Button(attachment.getName());
            attachmentLink.addStyleName("link");
            attachmentLink.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            return attachmentLink;
        }
        return new Link(attachment.getName(), (Resource)new ExternalResource(attachment.getUrl()));
    }

    public Component getDetailComponent(Attachment attachment) {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setSpacing(true);
        verticalLayout.setMargin(true);
        verticalLayout.addComponent((Component)new Label(attachment.getDescription()));
        HorizontalLayout linkLayout = new HorizontalLayout();
        linkLayout.setSpacing(true);
        verticalLayout.addComponent((Component)linkLayout);
        linkLayout.addComponent((Component)new Embedded(null, Images.RELATED_CONTENT_URL));
        Link link = new Link(attachment.getUrl(), (Resource)new ExternalResource(attachment.getUrl()));
        link.setTargetName("_blank");
        linkLayout.addComponent((Component)link);
        return verticalLayout;
    }

    public boolean canRenderAttachment(String type) {
        return ATTACHMENT_TYPE.equals(type);
    }
}

