/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Window;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;

public class ConfirmationDialogPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected GridLayout layout;
    protected Label descriptionLabel;
    protected Button yesButton;
    protected Button noButton;

    public ConfirmationDialogPopupWindow(String title, String description) {
        this.setWidth(400.0f, 0);
        this.setModal(true);
        this.setResizable(false);
        this.addStyleName("light");
        this.layout = new GridLayout(2, 2);
        this.layout.setMargin(true);
        this.layout.setSpacing(true);
        this.layout.setSizeFull();
        this.setContent((ComponentContainer)this.layout);
        I18nManager i18nManager = ExplorerApp.get().getI18nManager();
        if (title != null) {
            this.setCaption(title);
        } else {
            this.setCaption(i18nManager.getMessage("confirmation.dialog.default.title"));
        }
        this.initLabel(description);
        this.initButtons(i18nManager);
    }

    public ConfirmationDialogPopupWindow(String description) {
        this(null, description);
    }

    public void showConfirmation() {
        this.yesButton.focus();
        ExplorerApp.get().getViewManager().showPopupWindow((Window)this);
    }

    protected void initButtons(I18nManager i18nManager) {
        this.yesButton = new Button(i18nManager.getMessage("confirmation.dialog.yes"));
        this.layout.addComponent((Component)this.yesButton, 0, 1);
        this.layout.setComponentAlignment((Component)this.yesButton, Alignment.BOTTOM_RIGHT);
        this.yesButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.noButton = new Button(i18nManager.getMessage("confirmation.dialog.no"));
        this.layout.addComponent((Component)this.noButton, 1, 1);
        this.layout.setComponentAlignment((Component)this.noButton, Alignment.BOTTOM_LEFT);
        this.noButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initLabel(String description) {
        this.descriptionLabel = new Label(description, 3);
        this.descriptionLabel.setSizeFull();
        this.layout.addComponent((Component)this.descriptionLabel, 0, 0, 1, 0);
        this.layout.setRowExpandRatio(0, 1.0f);
    }

    static /* synthetic */ void access$000(ConfirmationDialogPopupWindow x0) {
        x0.close();
    }

    static /* synthetic */ void access$100(ConfirmationDialogPopupWindow x0, Component.Event x1) {
        x0.fireEvent(x1);
    }

    static /* synthetic */ void access$200(ConfirmationDialogPopupWindow x0) {
        x0.close();
    }

    static /* synthetic */ void access$300(ConfirmationDialogPopupWindow x0, Component.Event x1) {
        x0.fireEvent(x1);
    }
}

