/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.data.Item;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.MouseEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.cache.UserCache;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.PopupWindow;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectUsersPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected String title;
    protected boolean multiSelect = true;
    protected boolean showRoles = true;
    protected Collection<String> ignoredUserIds;
    protected UserCache userCache;
    protected I18nManager i18nManager;
    protected VerticalLayout windowLayout;
    protected TextField searchField;
    protected HorizontalLayout userSelectionLayout;
    protected Table matchingUsersTable;
    protected Button selectUserButton;
    protected Table selectedUsersTable;
    protected Button doneButton;

    public SelectUsersPopupWindow(String title, boolean multiSelect) {
        this.title = title;
        this.multiSelect = multiSelect;
        this.userCache = ExplorerApp.get().getUserCache();
        this.i18nManager = ExplorerApp.get().getI18nManager();
    }

    public SelectUsersPopupWindow(String title, boolean multiSelect, Collection<String> ignoredUserIds) {
        this(title, multiSelect);
        this.ignoredUserIds = ignoredUserIds;
    }

    public SelectUsersPopupWindow(String title, boolean multiSelect, boolean showRoles, Collection<String> ignoredUserIds) {
        this(title, multiSelect);
        this.showRoles = showRoles;
        this.ignoredUserIds = ignoredUserIds;
    }

    public void attach() {
        super.attach();
        this.initUi();
    }

    protected void initUi() {
        this.setCaption(this.title);
        this.setModal(true);
        this.addStyleName("light");
        this.center();
        this.windowLayout = (VerticalLayout)this.getContent();
        this.windowLayout.setSpacing(true);
        if (this.multiSelect && this.showRoles) {
            this.setWidth(820.0f, 0);
        } else if (this.multiSelect && !this.showRoles) {
            this.setWidth(685.0f, 0);
        } else {
            this.setWidth(340.0f, 0);
        }
        this.setHeight(350.0f, 0);
        this.initSearchField();
        this.initUserSelection();
        this.initDoneButton();
    }

    protected void initSearchField() {
        HorizontalLayout searchLayout = new HorizontalLayout();
        searchLayout.setSpacing(true);
        this.addComponent((Component)searchLayout);
        this.searchField = new TextField();
        this.searchField.setInputPrompt(this.i18nManager.getMessage("people.search"));
        this.searchField.setWidth(180.0f, 0);
        this.searchField.focus();
        searchLayout.addComponent((Component)this.searchField);
        this.searchField.addListener((FieldEvents.TextChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initSelectMyselfButton(searchLayout);
    }

    protected void initSelectMyselfButton(HorizontalLayout searchLayout) {
        LoggedInUser loggedInUser = ExplorerApp.get().getLoggedInUser();
        if (this.ignoredUserIds == null || !this.ignoredUserIds.contains(loggedInUser.getId())) {
            Button meButton = new Button(this.i18nManager.getMessage("people.select.myself"));
            meButton.setIcon(Images.USER_16);
            searchLayout.addComponent((Component)meButton);
            searchLayout.setComponentAlignment((Component)meButton, Alignment.MIDDLE_LEFT);
            if (this.multiSelect) {
                meButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                meButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    protected void searchPeople(String searchText) {
        if (searchText.length() >= 2) {
            this.matchingUsersTable.removeAllItems();
            List results = this.userCache.findMatchingUsers(searchText);
            for (User user : results) {
                if (this.multiSelect && this.selectedUsersTable.containsId((Object)user.getId()) || this.ignoredUserIds != null && this.ignoredUserIds.contains(user.getId())) continue;
                this.addMatchingUser(user.getId(), user.getFirstName() + " " + user.getLastName());
            }
        }
    }

    protected void addMatchingUser(String userId, String name) {
        if (!this.matchingUsersTable.containsId((Object)userId)) {
            Item item = this.matchingUsersTable.addItem((Object)userId);
            item.getItemProperty((Object)"userName").setValue((Object)name);
        }
    }

    protected void initUserSelection() {
        this.userSelectionLayout = new HorizontalLayout();
        this.userSelectionLayout.setSpacing(true);
        this.addComponent((Component)this.userSelectionLayout);
        this.initMatchingUsersTable();
        if (this.multiSelect) {
            this.initSelectUserButton();
            this.initSelectedUsersTable();
        }
    }

    protected void initMatchingUsersTable() {
        this.matchingUsersTable = new Table();
        this.matchingUsersTable.setColumnHeaderMode(-1);
        this.matchingUsersTable.setSelectable(true);
        this.matchingUsersTable.setEditable(false);
        this.matchingUsersTable.setImmediate(true);
        this.matchingUsersTable.setNullSelectionAllowed(false);
        this.matchingUsersTable.setSortDisabled(true);
        if (this.multiSelect) {
            this.matchingUsersTable.setMultiSelect(true);
        }
        this.matchingUsersTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.USER_16));
        this.matchingUsersTable.setColumnWidth((Object)"icon", 16);
        this.matchingUsersTable.addContainerProperty((Object)"userName", String.class, null);
        this.matchingUsersTable.setWidth(300.0f, 0);
        this.matchingUsersTable.setHeight(200.0f, 0);
        this.userSelectionLayout.addComponent((Component)this.matchingUsersTable);
    }

    protected void initSelectUserButton() {
        this.selectUserButton = new Button(">");
        this.selectUserButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.userSelectionLayout.addComponent((Component)this.selectUserButton);
        this.userSelectionLayout.setComponentAlignment((Component)this.selectUserButton, Alignment.MIDDLE_CENTER);
    }

    protected void initSelectedUsersTable() {
        this.selectedUsersTable = new Table();
        this.selectedUsersTable.setColumnHeaderMode(-1);
        this.selectedUsersTable.setEditable(false);
        this.selectedUsersTable.setSortDisabled(true);
        this.selectedUsersTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.USER_ADD));
        this.selectedUsersTable.setColumnWidth((Object)"icon", 16);
        this.selectedUsersTable.addContainerProperty((Object)"userName", String.class, null);
        if (this.showRoles) {
            this.selectedUsersTable.addContainerProperty((Object)"role", ComboBox.class, null);
        }
        this.selectedUsersTable.addGeneratedColumn((Object)"delete", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.DELETE, (MouseEvents.ClickListener)new /* Unavailable Anonymous Inner Class!! */));
        this.selectedUsersTable.setColumnWidth((Object)"icon", 16);
        if (this.showRoles) {
            this.selectedUsersTable.setWidth(420.0f, 0);
        } else {
            this.selectedUsersTable.setWidth(300.0f, 0);
        }
        this.selectedUsersTable.setHeight(200.0f, 0);
        this.userSelectionLayout.addComponent((Component)this.selectedUsersTable);
    }

    protected boolean matchesSearchField(String text) {
        for (String userNameToken : text.split(" ")) {
            if (!userNameToken.toLowerCase().startsWith(((String)this.searchField.getValue()).toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected void selectUser(String userId, String userName) {
        if (!this.selectedUsersTable.containsId((Object)userId)) {
            Item item = this.selectedUsersTable.addItem((Object)userId);
            item.getItemProperty((Object)"userName").setValue((Object)userName);
            if (this.showRoles) {
                ComboBox comboBox = new ComboBox(null, Arrays.asList(this.i18nManager.getMessage("task.role.contributor"), this.i18nManager.getMessage("task.role.implementer"), this.i18nManager.getMessage("task.role.manager"), this.i18nManager.getMessage("task.role.sponsor")));
                comboBox.select((Object)this.i18nManager.getMessage("task.role.contributor"));
                comboBox.setNewItemsAllowed(true);
                item.getItemProperty((Object)"role").setValue((Object)comboBox);
            }
        }
    }

    protected void initDoneButton() {
        this.doneButton = new Button("Done");
        this.doneButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addComponent((Component)this.doneButton);
        this.windowLayout.setComponentAlignment((Component)this.doneButton, Alignment.MIDDLE_RIGHT);
    }

    public String getSelectedUserId() {
        if (this.multiSelect) {
            throw new RuntimeException("Only use getSelectedUserId in non-multiselect mode");
        }
        return (String)this.matchingUsersTable.getValue();
    }

    public Collection<String> getSelectedUserIds() {
        if (!this.multiSelect) {
            throw new RuntimeException("Only use getSelectedUserIds in multiselect mode");
        }
        return this.selectedUsersTable.getItemIds();
    }

    public String getSelectedUserRole(String userId) {
        if (!this.multiSelect) {
            throw new RuntimeException("Only use getSelectedUserIds in multiselect mode");
        }
        return (String)((ComboBox)this.selectedUsersTable.getItem((Object)userId).getItemProperty((Object)"role").getValue()).getValue();
    }

    static /* synthetic */ void access$000(SelectUsersPopupWindow x0, Component.Event x1) {
        x0.fireEvent(x1);
    }

    static /* synthetic */ void access$100(SelectUsersPopupWindow x0) {
        x0.close();
    }

    static /* synthetic */ void access$200(SelectUsersPopupWindow x0, Component.Event x1) {
        x0.fireEvent(x1);
    }

    static /* synthetic */ void access$300(SelectUsersPopupWindow x0) {
        x0.close();
    }
}

