/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;

public class TabbedSelectionWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected HorizontalLayout windowLayout;
    protected Table selectionTable;
    protected String currentSelection;
    protected Component currentComponent;
    protected Map<String, Component> components = new HashMap();
    protected Map<String, Button.ClickListener> listeners = new HashMap();
    protected GridLayout selectedComponentLayout;
    protected Button okButton;

    public TabbedSelectionWindow(String title) {
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.initWindow(title);
        this.initWindowLayout();
        this.initSelectionTable();
        this.initComponentLayout();
        this.initActions();
    }

    protected void initWindow(String title) {
        this.setCaption(title);
        this.center();
        this.setModal(true);
        this.addStyleName("light");
    }

    protected void initWindowLayout() {
        this.windowLayout = new HorizontalLayout();
        this.windowLayout.setSpacing(false);
        this.windowLayout.setMargin(true);
        this.windowLayout.setSizeFull();
        this.setContent((ComponentContainer)this.windowLayout);
    }

    protected void initComponentLayout() {
        this.selectedComponentLayout = new GridLayout(1, 2);
        this.selectedComponentLayout.setSizeFull();
        this.selectedComponentLayout.setMargin(true);
        this.selectedComponentLayout.setSpacing(true);
        this.selectedComponentLayout.addStyleName("related-content-create-detail");
        this.windowLayout.addComponent((Component)this.selectedComponentLayout);
        this.windowLayout.setExpandRatio((Component)this.selectedComponentLayout, 1.0f);
        this.selectedComponentLayout.setRowExpandRatio(0, 1.0f);
        this.selectedComponentLayout.setColumnExpandRatio(0, 1.0f);
    }

    protected void initActions() {
        this.okButton = new Button(this.i18nManager.getMessage("button.ok"));
        this.selectedComponentLayout.addComponent((Component)this.okButton, 0, 1);
        this.okButton.setEnabled(false);
        this.okButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectedComponentLayout.setComponentAlignment((Component)this.okButton, Alignment.BOTTOM_RIGHT);
    }

    protected void initSelectionTable() {
        this.selectionTable = new Table();
        this.selectionTable.setSizeUndefined();
        this.selectionTable.setColumnHeaderMode(-1);
        this.selectionTable.setSelectable(true);
        this.selectionTable.setImmediate(true);
        this.selectionTable.setNullSelectionAllowed(false);
        this.selectionTable.setWidth(150.0f, 0);
        this.selectionTable.setHeight(100.0f, 8);
        this.selectionTable.setCellStyleGenerator((Table.CellStyleGenerator)new /* Unavailable Anonymous Inner Class!! */);
        this.selectionTable.addStyleName("related-content-create-list");
        this.selectionTable.addContainerProperty((Object)"type", Embedded.class, null);
        this.selectionTable.setColumnWidth((Object)"type", 22);
        this.selectionTable.addContainerProperty((Object)"name", String.class, null);
        this.selectionTable.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.windowLayout.addComponent((Component)this.selectionTable);
    }

    public void addSelectionItem(Embedded icon, String name, Component component, Button.ClickListener clickListener) {
        Item item = this.selectionTable.addItem((Object)name);
        item.getItemProperty((Object)"type").setValue((Object)icon);
        item.getItemProperty((Object)"name").setValue((Object)name);
        this.components.put(name, component);
        this.listeners.put(name, clickListener);
    }

    static /* synthetic */ void access$000(TabbedSelectionWindow x0) {
        x0.close();
    }
}

