/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.event.Action;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;

public class TaskListHeader
extends Panel {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected HorizontalLayout layout;
    protected TextField inputField;

    public TaskListHeader() {
        this.addStyleName("light");
        this.addStyleName("searchbox");
        this.layout = new HorizontalLayout();
        this.layout.setHeight(36.0f, 0);
        this.layout.setWidth(99.0f, 8);
        this.layout.setSpacing(true);
        this.layout.setMargin(false, true, false, true);
        this.setContent((ComponentContainer)this.layout);
        this.initInputField();
        this.initKeyboardListener();
    }

    protected void initInputField() {
        CssLayout csslayout = new CssLayout();
        csslayout.setHeight(24.0f, 0);
        csslayout.setWidth(100.0f, 8);
        this.layout.addComponent((Component)csslayout);
        this.inputField = new TextField();
        this.inputField.setWidth(100.0f, 8);
        this.inputField.addStyleName("searchbox");
        this.inputField.setInputPrompt(this.i18nManager.getMessage("task.create.new"));
        this.inputField.focus();
        csslayout.addComponent((Component)this.inputField);
        this.layout.setComponentAlignment((Component)csslayout, Alignment.MIDDLE_LEFT);
        this.layout.setExpandRatio((Component)csslayout, 1.0f);
    }

    protected void initKeyboardListener() {
        this.addActionHandler((Action.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initSortMenu() {
        MenuBar menuBar = new MenuBar();
        menuBar.addStyleName("searchbox-sortmenu");
        MenuBar.MenuItem rootItem = menuBar.addItem("Sort by", null);
        rootItem.addItem("Id", null);
        rootItem.addItem("Name", null);
        rootItem.addItem("Due date", null);
        rootItem.addItem("Creation date", null);
        this.layout.addComponent((Component)menuBar);
        this.layout.setComponentAlignment((Component)menuBar, Alignment.MIDDLE_RIGHT);
    }

    public void focus() {
        this.inputField.focus();
    }
}

