/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptAll;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.terminal.StreamVariable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.Html5File;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressIndicator;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;

public class UploadComponent
extends VerticalLayout
implements Upload.StartedListener,
Upload.FinishedListener,
Upload.FailedListener,
Upload.ProgressListener,
DropHandler {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected NotificationManager notificationManager;
    protected ProgressIndicator progressIndicator;
    protected Upload upload;
    protected Upload.Receiver receiver;
    protected List<Upload.FinishedListener> finishedListeners = new ArrayList();
    protected List<Upload.StartedListener> startedListeners = new ArrayList();
    protected boolean showGenericFailureMessage = true;
    protected List<Upload.FailedListener> failedListeners = new ArrayList();
    protected List<Upload.ProgressListener> progressListeners = new ArrayList();

    public UploadComponent(String description, Upload.Receiver receiver) {
        this.receiver = receiver;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.notificationManager = ExplorerApp.get().getNotificationManager();
        this.init(description);
    }

    protected void init(String description) {
        this.setSpacing(true);
        this.setSizeFull();
        this.addDescription(description);
        this.addUpload();
        this.addOrLabel();
        this.addDropPanel();
    }

    protected void addDescription(String description) {
        if (description != null) {
            Label descriptionLabel = new Label(description);
            descriptionLabel.addStyleName("light");
            descriptionLabel.addStyleName("upload-description");
            this.addComponent((Component)descriptionLabel);
        }
    }

    protected void addUpload() {
        this.upload = new Upload(null, this.receiver);
        this.upload.setButtonCaption(this.i18nManager.getMessage("upload.select"));
        this.upload.setImmediate(true);
        this.addComponent((Component)this.upload);
        this.setComponentAlignment((Component)this.upload, Alignment.MIDDLE_CENTER);
        this.upload.addListener((Upload.StartedListener)this);
        this.upload.addListener((Upload.FailedListener)this);
        this.upload.addListener((Upload.FinishedListener)this);
        this.upload.addListener((Upload.ProgressListener)this);
    }

    protected void addOrLabel() {
        Label orLabel = new Label("or");
        orLabel.setSizeUndefined();
        orLabel.addStyleName("light");
        this.addComponent((Component)orLabel);
        this.setComponentAlignment((Component)orLabel, Alignment.MIDDLE_CENTER);
    }

    protected void addDropPanel() {
        Panel dropPanel = new Panel();
        DragAndDropWrapper dragAndDropWrapper = new DragAndDropWrapper((Component)dropPanel);
        dragAndDropWrapper.setDropHandler((DropHandler)this);
        dragAndDropWrapper.setWidth("80%");
        this.addComponent((Component)dragAndDropWrapper);
        this.setComponentAlignment((Component)dragAndDropWrapper, Alignment.MIDDLE_CENTER);
        Label dropLabel = new Label(this.i18nManager.getMessage("upload.drop"));
        dropLabel.setSizeUndefined();
        dropPanel.addComponent((Component)dropLabel);
        ((VerticalLayout)dropPanel.getContent()).setComponentAlignment((Component)dropLabel, Alignment.MIDDLE_CENTER);
    }

    public void uploadStarted(Upload.StartedEvent event) {
        this.removeAllComponents();
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setPollingInterval(500);
        this.addComponent((Component)this.progressIndicator);
        this.setComponentAlignment((Component)this.progressIndicator, Alignment.MIDDLE_CENTER);
        for (Upload.StartedListener startedListener : this.startedListeners) {
            startedListener.uploadStarted(event);
        }
    }

    public void updateProgress(long readBytes, long contentLength) {
        this.progressIndicator.setValue((Object)new Float((float)readBytes / (float)contentLength));
        for (Upload.ProgressListener progressListener : this.progressListeners) {
            progressListener.updateProgress(readBytes, contentLength);
        }
    }

    public void uploadFinished(Upload.FinishedEvent event) {
        this.progressIndicator.setVisible(false);
        for (Upload.FinishedListener finishedListener : this.finishedListeners) {
            finishedListener.uploadFinished(event);
        }
    }

    public void uploadFailed(Upload.FailedEvent event) {
        for (Upload.FailedListener failedListener : this.failedListeners) {
            failedListener.uploadFailed(event);
        }
    }

    public void drop(DragAndDropEvent event) {
        DragAndDropWrapper.WrapperTransferable transferable = (DragAndDropWrapper.WrapperTransferable)event.getTransferable();
        Html5File[] files = transferable.getFiles();
        if (files.length > 0) {
            Html5File file = files[0];
            file.setStreamVariable((StreamVariable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public AcceptCriterion getAcceptCriterion() {
        return AcceptAll.get();
    }

    public void addFinishedListener(Upload.FinishedListener finishedListener) {
        this.finishedListeners.add(finishedListener);
    }

    public void addStartedListener(Upload.StartedListener startedListener) {
        this.startedListeners.add(startedListener);
    }

    public void addFailedListener(Upload.FailedListener failedListener) {
        this.failedListeners.add(failedListener);
    }

    public void addProgressListener(Upload.ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }
}

