/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.Application;
import com.vaadin.event.MouseEvents;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.cache.UserCache;
import org.activiti.explorer.ui.custom.UserProfileLink;
import org.activiti.explorer.ui.util.InputStreamStreamSource;

public class UserProfileLink
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    protected IdentityService identityService;
    protected ViewManager viewManager;
    protected UserCache userCache;

    public UserProfileLink(IdentityService identityService, boolean renderPicture, String userId) {
        this.identityService = identityService;
        this.viewManager = ExplorerApp.get().getViewManager();
        this.userCache = ExplorerApp.get().getUserCache();
        this.setSizeUndefined();
        this.setSpacing(true);
        this.addStyleName("profile-link");
        this.initPicture(identityService, renderPicture, userId);
        this.initUserLink(userId);
    }

    protected void initPicture(IdentityService identityService, boolean renderPicture, String userName) {
        Picture picture;
        if (renderPicture && (picture = identityService.getUserPicture(userName)) != null) {
            StreamResource imageResource = new StreamResource((StreamResource.StreamSource)new InputStreamStreamSource(picture.getInputStream()), userName + picture.getMimeType(), (Application)ExplorerApp.get());
            Embedded image = new Embedded(null, (Resource)imageResource);
            image.addStyleName("clickable");
            image.setType(1);
            image.setHeight(30.0f, 0);
            image.setWidth(30.0f, 0);
            image.addListener((MouseEvents.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.addComponent((Component)image);
            this.setComponentAlignment((Component)image, Alignment.MIDDLE_LEFT);
        }
    }

    protected void initUserLink(String userId) {
        User user = this.userCache.findUser(userId);
        Button userButton = new Button(user.getFirstName() + " " + user.getLastName());
        2 buttonClickListener = new /* Unavailable Anonymous Inner Class!! */;
        userButton.addStyleName("link");
        userButton.addListener((Button.ClickListener)buttonClickListener);
        this.addComponent((Component)userButton);
        this.setComponentAlignment((Component)userButton, Alignment.MIDDLE_LEFT);
    }
}

