/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.activiti.engine.FormService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.form.FormProperty;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.form.FormPropertiesComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormPropertiesForm
extends VerticalLayout {
    private static final long serialVersionUID = -3197331726904715949L;
    protected FormService formService = ProcessEngines.getDefaultProcessEngine().getFormService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Label formTitle;
    protected Button submitFormButton;
    protected Button cancelFormButton;
    protected FormPropertiesComponent formPropertiesComponent;

    public FormPropertiesForm() {
        this.addStyleName("block-holder");
        this.addStyleName("formprops");
        this.initTitle();
        this.initFormPropertiesComponent();
        this.initButtons();
        this.initListeners();
    }

    public void setFormProperties(List<FormProperty> formProperties) {
        this.formPropertiesComponent.setFormProperties(formProperties);
    }

    public void setSubmitButtonCaption(String caption) {
        this.submitFormButton.setCaption(caption);
    }

    public void setCancelButtonCaption(String caption) {
        this.cancelFormButton.setCaption(caption);
    }

    public void setFormHelp(String caption) {
        this.formTitle.setValue((Object)caption);
        this.formTitle.setVisible(caption != null);
    }

    public void clear() {
        this.formPropertiesComponent.setFormProperties(this.formPropertiesComponent.getFormProperties());
    }

    protected void initTitle() {
        this.formTitle = new Label();
        this.formTitle.addStyleName("h4");
        this.formTitle.setVisible(false);
        this.addComponent((Component)this.formTitle);
    }

    protected void initButtons() {
        this.submitFormButton = new Button();
        this.cancelFormButton = new Button();
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setSpacing(true);
        buttons.setWidth(100.0f, 8);
        buttons.addStyleName("block-holder");
        buttons.addComponent((Component)this.submitFormButton);
        buttons.setComponentAlignment((Component)this.submitFormButton, Alignment.BOTTOM_RIGHT);
        buttons.addComponent((Component)this.cancelFormButton);
        buttons.setComponentAlignment((Component)this.cancelFormButton, Alignment.BOTTOM_RIGHT);
        Label buttonSpacer = new Label();
        buttons.addComponent((Component)buttonSpacer);
        buttons.setExpandRatio((Component)buttonSpacer, 1.0f);
        this.addComponent((Component)buttons);
    }

    protected void initFormPropertiesComponent() {
        this.formPropertiesComponent = new FormPropertiesComponent();
        this.addComponent((Component)this.formPropertiesComponent);
    }

    protected void initListeners() {
        this.submitFormButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelFormButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }

    static /* synthetic */ void access$000(FormPropertiesForm x0, Component.Event x1) {
        x0.fireEvent(x1);
    }

    static /* synthetic */ void access$100(FormPropertiesForm x0, Component.Event x1) {
        x0.fireEvent(x1);
    }
}

