/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.data.Buffered;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import java.util.Collection;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectUserField
extends HorizontalLayout
implements Field {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected TextField wrappedField;
    protected Label selectedUserLabel;
    protected Button selectUserButton;
    protected User selectedUser;

    public SelectUserField(String caption) {
        this.setSpacing(true);
        this.setCaption(caption);
        this.selectedUserLabel = new Label();
        this.selectedUserLabel.setValue((Object)this.i18nManager.getMessage("form.user.no.user.selected"));
        this.selectedUserLabel.addStyleName("formprop-no-user-selected");
        this.addComponent((Component)this.selectedUserLabel);
        this.selectUserButton = new Button();
        this.selectUserButton.addStyleName("small");
        this.selectUserButton.setCaption(this.i18nManager.getMessage("form.user.select"));
        this.addComponent((Component)this.selectUserButton);
        this.selectUserButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrappedField = new TextField();
        this.wrappedField.setVisible(false);
        this.addComponent((Component)this.wrappedField);
    }

    public boolean isInvalidCommitted() {
        return this.wrappedField.isInvalidCommitted();
    }

    public void setInvalidCommitted(boolean isCommitted) {
        this.wrappedField.setInvalidCommitted(isCommitted);
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        this.wrappedField.commit();
    }

    public void discard() throws Buffered.SourceException {
        this.wrappedField.discard();
    }

    public boolean isWriteThrough() {
        return this.wrappedField.isWriteThrough();
    }

    public void setWriteThrough(boolean writeThrough) throws Buffered.SourceException, Validator.InvalidValueException {
        this.wrappedField.setWriteThrough(true);
    }

    public boolean isReadThrough() {
        return this.wrappedField.isReadThrough();
    }

    public void setReadThrough(boolean readThrough) throws Buffered.SourceException {
        this.wrappedField.setReadThrough(readThrough);
    }

    public boolean isModified() {
        return this.wrappedField.isModified();
    }

    public void addValidator(Validator validator) {
        this.wrappedField.addValidator(validator);
    }

    public void removeValidator(Validator validator) {
        this.wrappedField.removeValidator(validator);
    }

    public Collection<Validator> getValidators() {
        return this.wrappedField.getValidators();
    }

    public boolean isValid() {
        return this.wrappedField.isValid();
    }

    public void validate() throws Validator.InvalidValueException {
        this.wrappedField.validate();
    }

    public boolean isInvalidAllowed() {
        return this.wrappedField.isInvalidAllowed();
    }

    public void setInvalidAllowed(boolean invalidValueAllowed) throws UnsupportedOperationException {
        this.wrappedField.setInvalidAllowed(invalidValueAllowed);
    }

    public Object getValue() {
        return this.wrappedField.getValue();
    }

    public void setValue(Object newValue) throws Property.ReadOnlyException, Property.ConversionException {
        this.wrappedField.setValue(newValue);
        if (newValue != null) {
            if (this.selectedUser == null || !this.selectedUser.getId().equals(newValue)) {
                this.selectedUser = ExplorerApp.get().getUserCache().findUser((String)newValue);
            }
            this.selectedUserLabel.setValue(this.getSelectedUserLabel());
            this.selectedUserLabel.addStyleName("formprop-user-selected");
            this.selectedUserLabel.removeStyleName("formprop-no-user-selected");
        } else {
            this.selectedUser = null;
            this.selectedUserLabel.setValue((Object)this.i18nManager.getMessage("form.user.no.user.selected"));
            this.selectedUserLabel.addStyleName("formprop-no-user-selected");
            this.selectedUserLabel.removeStyleName("formprop-user-selected");
        }
    }

    protected Object getSelectedUserLabel() {
        if (this.selectedUser != null) {
            return this.selectedUser.getFirstName() + " " + this.selectedUser.getLastName();
        }
        return this.wrappedField.getValue();
    }

    public Class<?> getType() {
        return this.wrappedField.getType();
    }

    public void addListener(Property.ValueChangeListener listener) {
        this.wrappedField.addListener(listener);
    }

    public void removeListener(Property.ValueChangeListener listener) {
        this.wrappedField.removeListener(listener);
    }

    public void valueChange(Property.ValueChangeEvent event) {
        this.wrappedField.valueChange(event);
    }

    public void setPropertyDataSource(Property newDataSource) {
        this.wrappedField.setPropertyDataSource(newDataSource);
    }

    public Property getPropertyDataSource() {
        return this.wrappedField.getPropertyDataSource();
    }

    public int getTabIndex() {
        return this.wrappedField.getTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.wrappedField.setTabIndex(tabIndex);
    }

    public boolean isRequired() {
        return this.wrappedField.isRequired();
    }

    public void setRequired(boolean required) {
        this.wrappedField.setRequired(required);
    }

    public void setRequiredError(String requiredMessage) {
        this.wrappedField.setRequiredError(requiredMessage);
    }

    public String getRequiredError() {
        return this.wrappedField.getRequiredError();
    }

    public void focus() {
        this.wrappedField.focus();
    }
}

