/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.login;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.LoginForm;
import java.io.IOException;
import java.io.InputStream;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.login.ExplorerLoginForm;
import org.activiti.explorer.ui.login.LoginHandler;
import org.activiti.explorer.ui.login.LoginPage;

public class LoginPage
extends CustomLayout {
    private static final long serialVersionUID = 1L;
    protected IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected I18nManager i18nManager;
    protected ViewManager viewManager;
    protected NotificationManager notificationManager;
    protected LoginHandler loginHandler;

    public LoginPage() {
        InputStream loginHtmlStream = this.getClass().getResourceAsStream("/VAADIN/themes/activiti/layouts/login.html");
        if (loginHtmlStream != null) {
            try {
                this.initTemplateContentsFromInputStream(loginHtmlStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while loading login page template from classpath resource", e);
            }
        } else {
            this.setTemplateName("login");
        }
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.viewManager = ExplorerApp.get().getViewManager();
        this.notificationManager = ExplorerApp.get().getNotificationManager();
        this.loginHandler = ExplorerApp.get().getLoginHandler();
        this.addStyleName("login-general");
        this.initUi();
    }

    protected void initUi() {
        ExplorerLoginForm loginForm = new ExplorerLoginForm();
        this.addComponent((Component)loginForm, "login-content");
        loginForm.addListener((LoginForm.LoginListener)new ActivitiLoginListener(this));
    }

    protected void refreshUi() {
        this.removeAllComponents();
        this.initUi();
    }
}

