/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.mainlayout;

import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.mainlayout.MainMenuBar;
import org.activiti.explorer.ui.mainlayout.MainMenuBarFactory;

public class MainLayout
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected MainMenuBar mainMenuBar;
    protected CssLayout header;
    protected CssLayout main;
    protected CssLayout footer;

    public MainLayout() {
        this.setSizeFull();
        this.addStyleName("main");
        this.initHeader();
        this.initMainMenuBar();
        this.initMain();
        this.initFooter();
    }

    public void setMainContent(Component mainContent) {
        this.main.removeAllComponents();
        this.main.addComponent(mainContent);
    }

    public void setFooter(Component footerContent) {
        this.footer.removeAllComponents();
        this.footer.addComponent(footerContent);
    }

    public void setMainNavigation(String navigation) {
        this.mainMenuBar.setMainNavigation(navigation);
    }

    protected void initHeader() {
        this.header = new CssLayout();
        this.header.addStyleName("header");
        this.header.setWidth(100.0f, 8);
        this.addComponent((Component)this.header);
    }

    protected void initMain() {
        this.main = new CssLayout();
        this.main.setSizeFull();
        this.main.addStyleName("main-content");
        this.addComponent((Component)this.main);
        this.setExpandRatio((Component)this.main, 1.0f);
    }

    protected void initFooter() {
        this.footer = new CssLayout();
        this.footer.setWidth(100.0f, 8);
        this.footer.addStyleName("footer");
        this.addComponent((Component)this.footer);
        Label footerLabel = new Label();
        footerLabel.setContentMode(3);
        footerLabel.setValue((Object)this.i18nManager.getMessage("footer.message"));
        footerLabel.setWidth(100.0f, 8);
        this.footer.addComponent((Component)footerLabel);
    }

    protected void initMainMenuBar() {
        this.mainMenuBar = (MainMenuBar)ExplorerApp.get().getComponentFactory(MainMenuBarFactory.class).create();
        this.header.addComponent((Component)this.mainMenuBar);
    }
}

