/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management;

import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.custom.ToolbarEntry;
import org.activiti.explorer.ui.custom.ToolbarPopupEntry;
import org.activiti.explorer.ui.management.deployment.NewDeploymentListener;

public class ManagementMenuBar
extends ToolBar {
    private static final long serialVersionUID = 1L;
    public static final String ENTRY_DATABASE = "database";
    public static final String ENTRY_DEPLOYMENTS = "deployments";
    public static final String ENTRY_JOBS = "jobs";
    public static final String ENTRY_USERS = "users";
    public static final String ENTRY_GROUPS = "groups";
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();

    public ManagementMenuBar() {
        this.setWidth("100%");
        this.initToolbarEntries();
    }

    protected void initToolbarEntries() {
        this.addDatabaseToolbarEntry();
        this.addDeploymentsToolbarEntry();
        this.addJobsToolbarEntry();
        this.addUsersToolbarEntry();
        this.addGroupToolbarEntry();
    }

    protected void addDatabaseToolbarEntry() {
        this.addToolbarEntry(ENTRY_DATABASE, this.i18nManager.getMessage("management.menu.database"), (ToolbarEntry.ToolbarCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addDeploymentsToolbarEntry() {
        ToolbarPopupEntry deploymentEntry = this.addPopupEntry(ENTRY_DEPLOYMENTS, this.i18nManager.getMessage("management.menu.deployments"));
        deploymentEntry.addMenuItem(this.i18nManager.getMessage("management.menu.deployments.show.all"), (ToolbarEntry.ToolbarCommand)new /* Unavailable Anonymous Inner Class!! */);
        deploymentEntry.addMenuItem(this.i18nManager.getMessage("management.menu.deployments.upload"), (ToolbarEntry.ToolbarCommand)new NewDeploymentListener());
    }

    protected void addJobsToolbarEntry() {
        this.addToolbarEntry(ENTRY_JOBS, this.i18nManager.getMessage("management.menu.jobs"), (ToolbarEntry.ToolbarCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addUsersToolbarEntry() {
        this.addToolbarEntry(ENTRY_USERS, this.i18nManager.getMessage("management.menu.users"), (ToolbarEntry.ToolbarCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addGroupToolbarEntry() {
        this.addToolbarEntry(ENTRY_GROUPS, this.i18nManager.getMessage("management.menu.groups"), (ToolbarEntry.ToolbarCommand)new /* Unavailable Anonymous Inner Class!! */);
    }
}

