/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.db;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Table;
import java.util.TreeMap;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;

public class DatabasePage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected ManagementService managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
    protected String tableName;

    public DatabasePage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("database"));
    }

    public DatabasePage(String tableName) {
        this();
        this.tableName = tableName;
    }

    protected void initUi() {
        super.initUi();
        this.populateTableList();
        if (this.tableName == null) {
            this.selectElement(0);
        } else {
            this.table.select((Object)this.tableName);
        }
    }

    protected Table createList() {
        Table tableList = new Table();
        tableList.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        tableList.addContainerProperty((Object)"icon", Embedded.class, null);
        tableList.setColumnWidth((Object)"icon", 22);
        tableList.addContainerProperty((Object)"tableName", String.class, null);
        tableList.setColumnHeaderMode(-1);
        return tableList;
    }

    protected void populateTableList() {
        TreeMap tables = new TreeMap(this.managementService.getTableCount());
        for (String tableName : tables.keySet()) {
            Item item = this.table.addItem((Object)tableName);
            item.getItemProperty((Object)"icon").setValue((Object)this.determineTableIcon(tableName));
            item.getItemProperty((Object)"tableName").setValue((Object)(tableName + " (" + tables.get(tableName) + ")"));
        }
    }

    protected Embedded determineTableIcon(String tableName) {
        Resource image = null;
        image = tableName.contains("ACT_HI") ? Images.DATABASE_HISTORY : (tableName.contains("ACT_RU") ? Images.DATABASE_RUNTIME : (tableName.contains("ACT_RE") ? Images.DATABASE_REPOSITORY : (tableName.contains("ACT_ID") ? Images.DATABASE_IDENTITY : Images.DATABASE_22)));
        return new Embedded(null, image);
    }

    static /* synthetic */ void access$000(DatabasePage x0, Component x1) {
        x0.setDetailComponent(x1);
    }
}

