/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.data.LazyLoadingQuery;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.management.identity.GroupMembersQuery;
import org.activiti.explorer.ui.management.identity.GroupPage;
import org.activiti.explorer.ui.management.identity.MemberShipChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDetailPanel
extends DetailPanel
implements MemberShipChangeListener {
    private static final long serialVersionUID = 1L;
    protected IdentityService identityService;
    protected I18nManager i18nManager;
    protected GroupPage groupPage;
    protected Group group;
    protected VerticalLayout panelLayout;
    protected boolean editingDetails;
    protected HorizontalLayout detailLayout;
    protected GridLayout detailsGrid;
    protected TextField nameTextField;
    protected ComboBox typeCombobox;
    protected HorizontalLayout membersLayout;
    protected Table membersTable;
    protected Label noMembersTable;

    public GroupDetailPanel(GroupPage groupPage, String groupId) {
        this.groupPage = groupPage;
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.init();
    }

    protected void init() {
        this.setSizeFull();
        this.addStyleName("light");
        this.initPageTitle();
        this.initGroupDetails();
        this.initMembers();
        this.initActions();
    }

    protected void initActions() {
        Button createGroupButton = new Button(this.i18nManager.getMessage("group.create"));
        createGroupButton.setIcon(Images.GROUP_16);
        createGroupButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.groupPage.getToolBar().removeAllButtons();
        this.groupPage.getToolBar().addButton(createGroupButton);
    }

    protected void initPageTitle() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth(100.0f, 8);
        layout.addStyleName("title-block");
        layout.setSpacing(true);
        layout.setMargin(false, false, true, false);
        this.addDetailComponent((Component)layout);
        Embedded groupImage = new Embedded(null, Images.GROUP_50);
        layout.addComponent((Component)groupImage);
        Label groupName = new Label(this.getGroupName(this.group));
        groupName.setSizeUndefined();
        groupName.addStyleName("h2");
        layout.addComponent((Component)groupName);
        layout.setComponentAlignment((Component)groupName, Alignment.MIDDLE_LEFT);
        layout.setExpandRatio((Component)groupName, 1.0f);
    }

    protected String getGroupName(Group theGroup) {
        if (theGroup.getName() == null) {
            return theGroup.getId();
        }
        return this.group.getName();
    }

    protected void initGroupDetails() {
        Label groupDetailsHeader = new Label(this.i18nManager.getMessage("group.header.details"));
        groupDetailsHeader.addStyleName("h3");
        groupDetailsHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)groupDetailsHeader);
        this.detailLayout = new HorizontalLayout();
        this.detailLayout.setSpacing(true);
        this.detailLayout.setMargin(true, false, true, false);
        this.addDetailComponent((Component)this.detailLayout);
        this.populateGroupDetails();
    }

    protected void populateGroupDetails() {
        this.initGroupProperties();
        this.initGroupActions();
    }

    protected void initGroupProperties() {
        this.detailsGrid = new GridLayout(2, 3);
        this.detailsGrid.setSpacing(true);
        this.detailLayout.setMargin(true, true, true, false);
        this.detailLayout.addComponent((Component)this.detailsGrid);
        Label idLabel = new Label(this.i18nManager.getMessage("group.id") + ": ");
        idLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)idLabel);
        Label idValueLabel = new Label(this.group.getId());
        this.detailsGrid.addComponent((Component)idValueLabel);
        Label nameLabel = new Label(this.i18nManager.getMessage("group.name") + ": ");
        nameLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)nameLabel);
        if (!this.editingDetails) {
            Label nameValueLabel = new Label(this.group.getName());
            this.detailsGrid.addComponent((Component)nameValueLabel);
        } else {
            this.nameTextField = new TextField(null, this.group.getName());
            this.detailsGrid.addComponent((Component)this.nameTextField);
        }
        Label typeLabel = new Label(this.i18nManager.getMessage("group.type") + ": ");
        typeLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)typeLabel);
        if (!this.editingDetails) {
            Label typeValueLabel = new Label(this.group.getType());
            this.detailsGrid.addComponent((Component)typeValueLabel);
        } else {
            this.typeCombobox = new ComboBox(null, Arrays.asList("assignment", "security-role"));
            this.typeCombobox.setNullSelectionAllowed(false);
            this.typeCombobox.setInvalidAllowed(false);
            this.typeCombobox.select((Object)this.group.getType());
            this.detailsGrid.addComponent((Component)this.typeCombobox);
        }
    }

    protected void initGroupActions() {
        VerticalLayout actionsLayout = new VerticalLayout();
        actionsLayout.setSpacing(true);
        actionsLayout.setMargin(false, false, false, true);
        this.detailLayout.addComponent((Component)actionsLayout);
        if (this.editingDetails) {
            this.initSaveButton(actionsLayout);
        } else {
            this.initEditButton(actionsLayout);
            this.initDeleteButton(actionsLayout);
        }
    }

    protected void initEditButton(VerticalLayout actionsLayout) {
        Button editButton = new Button(this.i18nManager.getMessage("user.edit"));
        editButton.addStyleName("small");
        actionsLayout.addComponent((Component)editButton);
        editButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initSaveButton(VerticalLayout actionsLayout) {
        Button saveButton = new Button(this.i18nManager.getMessage("user.save"));
        saveButton.addStyleName("small");
        actionsLayout.addComponent((Component)saveButton);
        saveButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initDeleteButton(VerticalLayout actionsLayout) {
        Button deleteButton = new Button(this.i18nManager.getMessage("group.delete"));
        deleteButton.addStyleName("small");
        actionsLayout.addComponent((Component)deleteButton);
        deleteButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initMembers() {
        HorizontalLayout membersHeader = new HorizontalLayout();
        membersHeader.setSpacing(true);
        membersHeader.setWidth(100.0f, 8);
        membersHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)membersHeader);
        this.initMembersTitle(membersHeader);
        this.initAddMembersButton(membersHeader);
        this.membersLayout = new HorizontalLayout();
        this.membersLayout.setWidth(100.0f, 8);
        this.addDetailComponent((Component)this.membersLayout);
        this.initMembersTable();
    }

    protected void initMembersTitle(HorizontalLayout membersHeader) {
        Label usersHeader = new Label(this.i18nManager.getMessage("group.header.users"));
        usersHeader.addStyleName("h3");
        membersHeader.addComponent((Component)usersHeader);
    }

    protected void initAddMembersButton(HorizontalLayout membersHeader) {
        Button addButton = new Button();
        addButton.addStyleName("add");
        membersHeader.addComponent((Component)addButton);
        membersHeader.setComponentAlignment((Component)addButton, Alignment.MIDDLE_RIGHT);
        addButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<String> getCurrentMembers() {
        List users = this.identityService.createUserQuery().memberOfGroup(this.group.getId()).list();
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }

    protected void initMembersTable() {
        GroupMembersQuery query = new GroupMembersQuery(this.group.getId(), (MemberShipChangeListener)this);
        if (query.size() > 0) {
            this.membersTable = new Table();
            this.membersTable.setWidth(100.0f, 8);
            this.membersTable.setHeight(400.0f, 0);
            this.membersTable.setEditable(false);
            this.membersTable.setSelectable(false);
            this.membersTable.setSortDisabled(false);
            LazyLoadingContainer container = new LazyLoadingContainer((LazyLoadingQuery)query, 10);
            this.membersTable.setContainerDataSource((Container)container);
            this.membersTable.addContainerProperty((Object)"id", Button.class, null);
            this.membersTable.addContainerProperty((Object)"firstName", String.class, null);
            this.membersTable.addContainerProperty((Object)"lastName", String.class, null);
            this.membersTable.addContainerProperty((Object)"email", String.class, null);
            this.membersTable.addContainerProperty((Object)"actions", Component.class, null);
            this.membersLayout.addComponent((Component)this.membersTable);
        } else {
            this.noMembersTable = new Label(this.i18nManager.getMessage("group.no.members"));
            this.membersLayout.addComponent((Component)this.noMembersTable);
        }
    }

    public void notifyMembershipChanged() {
        this.membersLayout.removeAllComponents();
        this.initMembersTable();
    }
}

