/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.management.identity.GroupMembersQuery;
import org.activiti.explorer.ui.management.identity.MemberShipChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMembersQuery
extends AbstractLazyLoadingQuery {
    protected String groupId;
    protected MemberShipChangeListener memberShipChangeListener;
    protected IdentityService identityService;
    protected String sortby;
    protected boolean ascending;

    public GroupMembersQuery(String groupId, MemberShipChangeListener memberShipChangeListener) {
        this.groupId = groupId;
        this.memberShipChangeListener = memberShipChangeListener;
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    }

    public int size() {
        return (int)this.identityService.createUserQuery().memberOfGroup(this.groupId).count();
    }

    public List<Item> loadItems(int start, int count) {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup(this.groupId);
        if (this.sortby == null || "id".equals(this.sortby)) {
            query.orderByUserId();
        } else if ("firstName".equals(this.sortby)) {
            query.orderByUserFirstName();
        } else if ("lastName".equals(this.sortby)) {
            query.orderByUserLastName();
        } else if ("email".equals(this.sortby)) {
            query.orderByUserEmail();
        }
        if (this.sortby == null || this.ascending) {
            query.asc();
        } else {
            query.desc();
        }
        List users = query.listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (User user : users) {
            items.add((Item)new GroupMemberItem(this, user));
        }
        return items;
    }

    public Item loadSingleResult(String id) {
        throw new UnsupportedOperationException();
    }

    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        if (propertyIds.length > 0) {
            this.sortby = propertyIds[0].toString();
            this.ascending = ascending[0];
        }
    }
}

