/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.data.LazyLoadingQuery;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.identity.GroupListQuery;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class GroupPage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected String groupId;
    protected Table groupTable;
    protected LazyLoadingQuery groupListQuery;
    protected LazyLoadingContainer groupListContainer;

    public GroupPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("group"));
    }

    public GroupPage(String groupId) {
        this.groupId = groupId;
    }

    protected void initUi() {
        super.initUi();
        if (this.groupId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.groupListContainer.getIndexForObjectId(this.groupId));
        }
    }

    protected Table createList() {
        this.groupTable = new Table();
        this.groupTable.setEditable(false);
        this.groupTable.setImmediate(true);
        this.groupTable.setSelectable(true);
        this.groupTable.setNullSelectionAllowed(false);
        this.groupTable.setSortDisabled(true);
        this.groupTable.setSizeFull();
        this.groupListQuery = new GroupListQuery();
        this.groupListContainer = new LazyLoadingContainer(this.groupListQuery, 20);
        this.groupTable.setContainerDataSource((Container)this.groupListContainer);
        this.groupTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.GROUP_22));
        this.groupTable.setColumnWidth((Object)"icon", 22);
        this.groupTable.addContainerProperty((Object)"name", String.class, null);
        this.groupTable.setColumnHeaderMode(-1);
        this.groupTable.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.groupTable;
    }

    public void notifyGroupChanged(String groupId) {
        this.groupTable.removeAllItems();
        this.groupListContainer.removeAllItems();
        this.groupTable.select((Object)this.groupListContainer.getIndexForObjectId(groupId));
    }

    static /* synthetic */ void access$000(GroupPage x0, Component x1) {
        x0.setDetailComponent(x1);
    }

    static /* synthetic */ void access$100(GroupPage x0, Component x1) {
        x0.setDetailComponent(x1);
    }
}

