/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.management.identity.GroupSelectionQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSelectionQuery
extends AbstractLazyLoadingQuery {
    protected IdentityService identityService;
    protected String userId;

    public GroupSelectionQuery(IdentityService identityService, String userId) {
        this.identityService = identityService;
        this.userId = userId;
    }

    public int size() {
        return (int)(this.identityService.createGroupQuery().count() - this.identityService.createGroupQuery().groupMember(this.userId).count());
    }

    public List<Item> loadItems(int start, int count) {
        ArrayList<Item> groupItems = new ArrayList<Item>();
        Set currentGroups = this.getCurrentGroups();
        int nrFound = 0;
        int tries = 0;
        while (nrFound == 0) {
            List groups = ((GroupQuery)((GroupQuery)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).orderByGroupId().asc()).orderByGroupName().asc()).listPage(start + tries * count, count);
            for (Group group : groups) {
                if (currentGroups.contains(group.getId())) continue;
                ++nrFound;
                groupItems.add((Item)new GroupSelectionItem(this, group));
            }
            ++tries;
        }
        return groupItems;
    }

    protected Set<String> getCurrentGroups() {
        HashSet<String> groupIds = new HashSet<String>();
        List currentGroups = this.identityService.createGroupQuery().groupMember(this.userId).list();
        for (Group group : currentGroups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    public Item loadSingleResult(String id) {
        throw new UnsupportedOperationException();
    }

    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }
}

