/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Validator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.event.Action;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;

public class NewUserPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Form form;

    public NewUserPopupWindow() {
        this.setCaption(this.i18nManager.getMessage("user.create"));
        this.setModal(true);
        this.center();
        this.setResizable(false);
        this.setWidth(275.0f, 0);
        this.setHeight(300.0f, 0);
        this.addStyleName("light");
        this.initEnterKeyListener();
        this.initForm();
    }

    protected void initEnterKeyListener() {
        this.addActionHandler((Action.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initForm() {
        this.form = new Form();
        this.form.setValidationVisibleOnCommit(true);
        this.form.setImmediate(true);
        this.addComponent((Component)this.form);
        this.initInputFields();
        this.initCreateButton();
    }

    protected void initInputFields() {
        this.form.addField((Object)"id", (Field)new TextField(this.i18nManager.getMessage("user.id")));
        this.form.getField((Object)"id").setRequired(true);
        this.form.getField((Object)"id").setRequiredError(this.i18nManager.getMessage("user.id.required"));
        this.form.getField((Object)"id").focus();
        this.form.getField((Object)"id").addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        this.form.addField((Object)"password", (Field)new PasswordField(this.i18nManager.getMessage("user.password")));
        this.form.getField((Object)"password").setRequired(true);
        this.form.getField((Object)"password").setRequiredError(this.i18nManager.getMessage("user.password.required"));
        StringLengthValidator passwordLengthValidator = new StringLengthValidator(this.i18nManager.getMessage("user.password.min.lenth", new Object[]{5}), 5, -1, false);
        this.form.getField((Object)"password").addValidator((Validator)passwordLengthValidator);
        this.form.addField((Object)"firstName", (Field)new TextField(this.i18nManager.getMessage("user.firstname")));
        this.form.addField((Object)"lastName", (Field)new TextField(this.i18nManager.getMessage("user.lastname")));
        this.form.addField((Object)"email", (Field)new TextField(this.i18nManager.getMessage("user.email")));
    }

    protected void initCreateButton() {
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidth(100.0f, 8);
        this.form.getFooter().setWidth(100.0f, 8);
        this.form.getFooter().addComponent((Component)buttonLayout);
        Button createButton = new Button(this.i18nManager.getMessage("user.create"));
        buttonLayout.addComponent((Component)createButton);
        buttonLayout.setComponentAlignment((Component)createButton, Alignment.BOTTOM_RIGHT);
        createButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void handleFormSubmit() {
        try {
            this.form.commit();
            User user = this.createUser();
            this.close();
            ExplorerApp.get().getViewManager().showUserPage(user.getId());
            ExplorerApp.get().getUserCache().notifyUserDataChanged(user.getId());
        }
        catch (Validator.InvalidValueException e) {
            this.setHeight(340.0f, 0);
        }
    }

    protected User createUser() {
        User user = this.identityService.newUser(this.form.getField((Object)"id").getValue().toString());
        user.setPassword(this.form.getField((Object)"password").getValue().toString());
        if (this.form.getField((Object)"firstName").getValue() != null) {
            user.setFirstName(this.form.getField((Object)"firstName").getValue().toString());
        }
        if (this.form.getField((Object)"lastName").getValue() != null) {
            user.setLastName(this.form.getField((Object)"lastName").getValue().toString());
        }
        if (this.form.getField((Object)"email").getValue() != null) {
            user.setEmail(this.form.getField((Object)"email").getValue().toString());
        }
        this.identityService.saveUser(user);
        return user;
    }
}

