/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.job;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.runtime.Job;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;
import org.activiti.explorer.ui.management.job.JobPage;

public class JobDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected ManagementService managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected NotificationManager notificationManager = ExplorerApp.get().getNotificationManager();
    protected Job job;
    protected JobPage jobPage;

    public JobDetailPanel(String jobId, JobPage jobPage) {
        this.job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        this.jobPage = jobPage;
        this.init();
    }

    protected void init() {
        this.addHeader();
        this.addJobState();
        this.addActions();
    }

    protected void addActions() {
        Button executeButton = new Button(this.i18nManager.getMessage("job.execute"));
        executeButton.setIcon(Images.EXECUTE);
        executeButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jobPage.getToolBar().removeAllButtons();
        this.jobPage.getToolBar().addButton(executeButton);
    }

    protected void addHeader() {
        GridLayout taskDetails = new GridLayout(3, 2);
        taskDetails.setWidth(100.0f, 8);
        taskDetails.addStyleName("title-block");
        taskDetails.setSpacing(true);
        taskDetails.setMargin(false, false, true, false);
        Embedded image = new Embedded(null, Images.JOB_50);
        taskDetails.addComponent((Component)image, 0, 0, 0, 1);
        Label nameLabel = new Label(this.getJobLabel(this.job));
        nameLabel.addStyleName("h2");
        taskDetails.addComponent((Component)nameLabel, 1, 0, 2, 0);
        PrettyTimeLabel dueDateLabel = new PrettyTimeLabel(this.i18nManager.getMessage("job.duedate"), this.job.getDuedate(), this.i18nManager.getMessage("job.no.dudedate"), false);
        dueDateLabel.addStyleName("job-duedate");
        taskDetails.addComponent((Component)dueDateLabel, 1, 1);
        taskDetails.setColumnExpandRatio(1, 1.0f);
        taskDetails.setColumnExpandRatio(2, 1.0f);
        this.addDetailComponent((Component)taskDetails);
    }

    protected String getJobLabel(Job theJob) {
        if (theJob instanceof TimerEntity) {
            return this.i18nManager.getMessage("job.timer", new Object[]{theJob.getId()});
        }
        if (theJob instanceof MessageEntity) {
            return this.i18nManager.getMessage("job.message", new Object[]{theJob.getId()});
        }
        return this.i18nManager.getMessage("job.default.name", new Object[]{theJob.getId()});
    }

    protected void addJobState() {
        Label processDefinitionHeader = new Label(this.i18nManager.getMessage("job.header.execution"));
        processDefinitionHeader.addStyleName("h3");
        processDefinitionHeader.addStyleName("block-holder");
        processDefinitionHeader.setWidth(100.0f, 8);
        this.addComponent((Component)processDefinitionHeader);
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setSizeFull();
        layout.setMargin(true, false, true, false);
        this.addDetailComponent((Component)layout);
        this.setDetailExpandRatio((Component)layout, 1.0f);
        if (this.job.getExceptionMessage() != null) {
            Label retrieslabel = new Label(this.getRetriesLabel(this.job));
            layout.addComponent((Component)retrieslabel);
            Label exceptionMessageLabel = new Label(this.i18nManager.getMessage("job.error") + ": " + this.job.getExceptionMessage());
            exceptionMessageLabel.addStyleName("job-exception-message");
            layout.addComponent((Component)exceptionMessageLabel);
            String stack = this.managementService.getJobExceptionStacktrace(this.job.getId());
            Label stackTraceLabel = new Label(stack);
            stackTraceLabel.setContentMode(1);
            stackTraceLabel.addStyleName("job-exception-trace");
            stackTraceLabel.setSizeFull();
            Panel stackPanel = new Panel();
            stackPanel.setWidth(100.0f, 8);
            stackPanel.setSizeFull();
            stackPanel.setScrollable(true);
            stackPanel.addComponent((Component)stackTraceLabel);
            layout.addComponent((Component)stackPanel);
            layout.setExpandRatio((Component)stackPanel, 1.0f);
        } else {
            Label noException = new Label(this.i18nManager.getMessage("job.not.executed"));
            layout.addComponent((Component)noException);
            layout.setExpandRatio((Component)noException, 1.0f);
        }
    }

    protected String getRetriesLabel(Job theJob) {
        String retriesString = theJob.getRetries() <= 0 ? this.i18nManager.getMessage("job.no.retries") : this.i18nManager.getMessage("job.retries", new Object[]{theJob.getRetries()});
        return retriesString;
    }
}

