/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.process;

import com.vaadin.data.Item;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import java.util.TreeMap;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.AbstractTablePage;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;
import org.activiti.explorer.ui.custom.UserProfileLink;
import org.activiti.explorer.ui.management.process.DeleteProcessInstanceClickListener;
import org.activiti.explorer.ui.process.ProcessDefinitionImageStreamResourceBuilder;
import org.activiti.explorer.ui.variable.VariableRendererManager;

public class ProcessInstanceDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected I18nManager i18nManager;
    protected VariableRendererManager variableRendererManager;
    protected ProcessInstance processInstance;
    protected AbstractTablePage processInstancePage;
    protected HistoricProcessInstance historicProcessInstance;
    protected ProcessDefinition processDefinition;
    protected VerticalLayout panelLayout;

    public ProcessInstanceDetailPanel(String processInstanceId, AbstractTablePage processInstancePage) {
        this.processInstancePage = processInstancePage;
        this.runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
        this.repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.variableRendererManager = ExplorerApp.get().getVariableRendererManager();
        this.processInstance = this.getProcessInstance(processInstanceId);
        this.processDefinition = this.getProcessDefinition(this.processInstance.getProcessDefinitionId());
        this.historicProcessInstance = this.getHistoricProcessInstance(processInstanceId);
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.init();
    }

    protected void init() {
        this.addStyleName("white");
        this.setSizeFull();
        this.panelLayout = new VerticalLayout();
        this.panelLayout.setWidth(100.0f, 8);
        this.panelLayout.setMargin(true);
        this.setDetailContainer((ComponentContainer)this.panelLayout);
        this.addHeader();
        this.addProcessImage();
        this.addTasks();
        this.addVariables();
        this.addDeleteButton();
    }

    protected void addHeader() {
        GridLayout header = new GridLayout(3, 2);
        header.setWidth(100.0f, 8);
        header.addStyleName("title-block");
        header.setSpacing(true);
        header.setMargin(false, false, true, false);
        Embedded image = new Embedded(null, Images.PROCESS_50);
        header.addComponent((Component)image, 0, 0, 0, 1);
        Label nameLabel = new Label(this.getProcessDisplayName(this.processDefinition, this.processInstance));
        nameLabel.addStyleName("h2");
        header.addComponent((Component)nameLabel, 1, 0, 2, 0);
        PrettyTimeLabel startTimeLabel = new PrettyTimeLabel(this.i18nManager.getMessage("process.start.time"), this.historicProcessInstance.getStartTime(), null, true);
        startTimeLabel.addStyleName("process-start-time");
        header.addComponent((Component)startTimeLabel, 1, 1);
        header.setColumnExpandRatio(1, 1.0f);
        header.setColumnExpandRatio(2, 1.0f);
        this.panelLayout.addComponent((Component)header);
    }

    protected void addProcessImage() {
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.processDefinition.getId());
        if (processDefinitionEntity != null && processDefinitionEntity.isGraphicalNotationDefined()) {
            Label header = new Label(this.i18nManager.getMessage("process.header.diagram"));
            header.addStyleName("h3");
            header.addStyleName("block-holder");
            header.addStyleName("no-line");
            this.panelLayout.addComponent((Component)header);
            StreamResource diagram = new ProcessDefinitionImageStreamResourceBuilder().buildStreamResource(this.processInstance, this.repositoryService, this.runtimeService);
            Embedded embedded = new Embedded(null, (Resource)diagram);
            embedded.setType(1);
            embedded.setSizeUndefined();
            Panel imagePanel = new Panel();
            imagePanel.setScrollable(true);
            imagePanel.addStyleName("light");
            imagePanel.setWidth(100.0f, 8);
            imagePanel.setHeight(400.0f, 0);
            HorizontalLayout panelLayoutT = new HorizontalLayout();
            panelLayoutT.setSizeUndefined();
            imagePanel.setContent((ComponentContainer)panelLayoutT);
            imagePanel.addComponent((Component)embedded);
            this.panelLayout.addComponent((Component)imagePanel);
        }
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition, ProcessInstance processInstance) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName() + " (" + processInstance.getId() + ")";
        }
        return processDefinition.getKey() + " (" + processInstance.getId() + ")";
    }

    protected void addTasks() {
        Label header = new Label(this.i18nManager.getMessage("process.instance.header.tasks"));
        header.addStyleName("h3");
        header.addStyleName("block-holder");
        header.addStyleName("no-line");
        this.panelLayout.addComponent((Component)header);
        this.panelLayout.addComponent((Component)new Label("&nbsp;", 3));
        Table taskTable = new Table();
        taskTable.addStyleName("proc-inst-task-list");
        taskTable.setWidth(100.0f, 8);
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(this.processInstance.getId()).orderByHistoricTaskInstanceEndTime().desc()).orderByHistoricActivityInstanceStartTime().desc()).list();
        if (tasks.size() > 0) {
            taskTable.addContainerProperty((Object)"finished", Component.class, null, "", null, "c");
            taskTable.setColumnWidth((Object)"finished", 22);
            taskTable.addContainerProperty((Object)"name", String.class, null, this.i18nManager.getMessage("task.name"), null, "b");
            taskTable.addContainerProperty((Object)"priority", Integer.class, null, this.i18nManager.getMessage("task.priority"), null, "b");
            taskTable.addContainerProperty((Object)"assignee", Component.class, null, this.i18nManager.getMessage("task.assignee"), null, "b");
            taskTable.addContainerProperty((Object)"dueDate", Component.class, null, this.i18nManager.getMessage("task.duedate"), null, "b");
            taskTable.addContainerProperty((Object)"startDate", Component.class, null, this.i18nManager.getMessage("task.create.time"), null, "b");
            taskTable.addContainerProperty((Object)"endDate", Component.class, null, this.i18nManager.getMessage("task.complete.time"), null, "b");
            this.panelLayout.addComponent((Component)taskTable);
            this.panelLayout.setExpandRatio((Component)taskTable, 1.0f);
            for (HistoricTaskInstance task : tasks) {
                this.addTaskItem(task, taskTable);
            }
            taskTable.setPageLength(taskTable.size());
        } else {
            Label noTaskLabel = new Label(this.i18nManager.getMessage("process.instance.no.tasks"));
            this.panelLayout.addComponent((Component)noTaskLabel);
        }
    }

    protected void addTaskItem(HistoricTaskInstance task, Table taskTable) {
        Component taskAssigneeComponent;
        Item item = taskTable.addItem((Object)task.getId());
        if (task.getEndTime() != null) {
            item.getItemProperty((Object)"finished").setValue((Object)new Embedded(null, Images.TASK_FINISHED_22));
        } else {
            item.getItemProperty((Object)"finished").setValue((Object)new Embedded(null, Images.TASK_22));
        }
        item.getItemProperty((Object)"name").setValue((Object)task.getName());
        item.getItemProperty((Object)"priority").setValue((Object)task.getPriority());
        item.getItemProperty((Object)"startDate").setValue((Object)new PrettyTimeLabel(task.getStartTime(), true));
        item.getItemProperty((Object)"endDate").setValue((Object)new PrettyTimeLabel(task.getEndTime(), true));
        if (task.getDueDate() != null) {
            PrettyTimeLabel dueDateLabel = new PrettyTimeLabel(task.getEndTime(), this.i18nManager.getMessage("task.not.finished.yet"), true);
            item.getItemProperty((Object)"dueDate").setValue((Object)dueDateLabel);
        }
        if (task.getAssignee() != null && (taskAssigneeComponent = this.getTaskAssigneeComponent(task.getAssignee())) != null) {
            item.getItemProperty((Object)"assignee").setValue((Object)taskAssigneeComponent);
        }
    }

    protected Component getTaskAssigneeComponent(String assignee) {
        return new UserProfileLink(this.identityService, true, assignee);
    }

    protected void addVariables() {
        Label header = new Label(this.i18nManager.getMessage("process.instance.header.variables"));
        header.addStyleName("h3");
        header.addStyleName("block-holder");
        header.addStyleName("no-line");
        this.panelLayout.addComponent((Component)header);
        this.panelLayout.addComponent((Component)new Label("&nbsp;", 3));
        TreeMap variables = new TreeMap(this.runtimeService.getVariables(this.processInstance.getId()));
        if (variables.size() > 0) {
            Table variablesTable = new Table();
            variablesTable.setWidth(60.0f, 8);
            variablesTable.addStyleName("proc-inst-task-list");
            variablesTable.addContainerProperty((Object)"name", String.class, null, this.i18nManager.getMessage("process.instance.variable.name"), null, "b");
            variablesTable.addContainerProperty((Object)"value", String.class, null, this.i18nManager.getMessage("process.instance.variable.value"), null, "b");
            for (String variable : variables.keySet()) {
                Item variableItem = variablesTable.addItem((Object)variable);
                variableItem.getItemProperty((Object)"name").setValue((Object)variable);
                String theValue = this.variableRendererManager.getStringRepresentation(variables.get(variable));
                variableItem.getItemProperty((Object)"value").setValue((Object)theValue);
            }
            variablesTable.setPageLength(variables.size());
            this.panelLayout.addComponent((Component)variablesTable);
        } else {
            Label noVariablesLabel = new Label(this.i18nManager.getMessage("process.instance.no.variables"));
            this.panelLayout.addComponent((Component)noVariablesLabel);
        }
    }

    protected void addDeleteButton() {
        Button deleteProcessInstanceButton = new Button(this.i18nManager.getMessage("process.instance.delete"));
        deleteProcessInstanceButton.setIcon(Images.DELETE);
        deleteProcessInstanceButton.addListener((Button.ClickListener)new DeleteProcessInstanceClickListener(this.processInstance.getId(), this.processInstancePage));
        this.processInstancePage.getToolBar().removeAllButtons();
        this.processInstancePage.getToolBar().addButton(deleteProcessInstanceButton);
    }

    protected ProcessInstance getProcessInstance(String processInstanceId) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected HistoricProcessInstance getHistoricProcessInstance(String processInstanceId) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }
}

