/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.process;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.management.process.ProcessInstanceListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceListQuery
extends AbstractLazyLoadingQuery {
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected Map<String, String> cachedProcessDefinitionNames = new HashMap();

    public ProcessInstanceListQuery() {
        this.runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
        this.repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    }

    public int size() {
        return (int)this.constructQuery().count();
    }

    public List<Item> loadItems(int start, int count) {
        List processInstances = this.constructQuery().listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (ProcessInstance processInstance : processInstances) {
            items.add((Item)new ProcessInstanceListItem(processInstance, this.getProcessDefinitionName(processInstance.getProcessDefinitionId())));
        }
        return items;
    }

    public Item loadSingleResult(String id) {
        ProcessInstance processInstance = (ProcessInstance)this.constructQuery().processInstanceId(id).singleResult();
        return new ProcessInstanceListItem(processInstance, processInstance.getProcessDefinitionId());
    }

    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    protected ProcessInstanceQuery constructQuery() {
        return (ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().asc();
    }

    protected String getProcessDefinitionName(String processDefinitionId) {
        if (!this.cachedProcessDefinitionNames.containsKey(processDefinitionId)) {
            ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            String name = definition.getName();
            if (name != null) {
                name = definition.getKey();
            }
            this.cachedProcessDefinitionNames.put(processDefinitionId, name);
        }
        return (String)this.cachedProcessDefinitionNames.get(processDefinitionId);
    }
}

