/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.FormService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;
import org.activiti.explorer.ui.form.FormPropertiesForm;
import org.activiti.explorer.ui.process.ProcessDefinitionInfoComponent;
import org.activiti.explorer.ui.process.ProcessDefinitionPage;
import org.activiti.explorer.ui.process.listener.StartProcessInstanceClickListener;

public class ProcessDefinitionDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected ProcessDefinition processDefinition;
    protected Deployment deployment;
    protected ProcessDefinitionPage processDefinitionPage;
    protected RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected FormService formService = ProcessEngines.getDefaultProcessEngine().getFormService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected VerticalLayout detailPanelLayout;
    protected HorizontalLayout detailContainer;
    protected HorizontalLayout actionsContainer;
    protected Label nameLabel;
    protected Button startProcessInstanceButton;
    protected FormPropertiesForm processDefinitionStartForm;
    protected ProcessDefinitionInfoComponent definitionInfoComponent;

    public ProcessDefinitionDetailPanel(String processDefinitionId, ProcessDefinitionPage processDefinitionPage) {
        this.processDefinitionPage = processDefinitionPage;
        this.processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (this.processDefinition != null) {
            this.deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(this.processDefinition.getDeploymentId()).singleResult();
        }
        this.initUi();
    }

    protected void initUi() {
        this.setSizeFull();
        this.addStyleName("white");
        this.detailPanelLayout = new VerticalLayout();
        this.detailPanelLayout.setWidth(100.0f, 8);
        this.detailPanelLayout.setMargin(true);
        this.setDetailContainer((ComponentContainer)this.detailPanelLayout);
        this.initHeader();
        this.detailContainer = new HorizontalLayout();
        this.detailContainer.addStyleName("light");
        this.detailPanelLayout.addComponent((Component)this.detailContainer);
        this.detailContainer.setSizeFull();
        this.initActions();
        this.initProcessDefinitionInfo();
    }

    protected void initActions() {
        this.startProcessInstanceButton = new Button(this.i18nManager.getMessage("process.start"));
        this.startProcessInstanceButton.addListener((Button.ClickListener)new StartProcessInstanceClickListener(this.processDefinition, this.processDefinitionPage));
        this.processDefinitionPage.getToolBar().removeAllButtons();
        this.processDefinitionPage.getToolBar().addButton(this.startProcessInstanceButton);
    }

    public void initProcessDefinitionInfo() {
        if (this.definitionInfoComponent == null) {
            this.definitionInfoComponent = new ProcessDefinitionInfoComponent(this.processDefinition, this.deployment);
        }
        if (this.startProcessInstanceButton != null) {
            this.startProcessInstanceButton.setEnabled(true);
        }
        this.detailContainer.removeAllComponents();
        this.detailContainer.addComponent((Component)this.definitionInfoComponent);
    }

    public void showProcessStartForm(StartFormData startFormData) {
        if (this.processDefinitionStartForm == null) {
            this.processDefinitionStartForm = new FormPropertiesForm();
            this.processDefinitionStartForm.setSubmitButtonCaption("Start process");
            this.processDefinitionStartForm.setCancelButtonCaption("Cancel");
            this.processDefinitionStartForm.addListener((Component.Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.processDefinitionStartForm.setFormProperties(startFormData.getFormProperties());
        this.startProcessInstanceButton.setEnabled(false);
        this.detailContainer.removeAllComponents();
        this.detailContainer.addComponent((Component)this.processDefinitionStartForm);
    }

    protected void initHeader() {
        GridLayout details = new GridLayout(2, 2);
        details.setWidth(100.0f, 8);
        details.addStyleName("title-block");
        details.setSpacing(true);
        details.setMargin(false, false, true, false);
        details.setColumnExpandRatio(1, 1.0f);
        this.detailPanelLayout.addComponent((Component)details);
        Embedded image = new Embedded(null, Images.PROCESS_50);
        details.addComponent((Component)image, 0, 0, 0, 1);
        Label nameLabel = new Label(this.getProcessDisplayName(this.processDefinition));
        nameLabel.addStyleName("h2");
        details.addComponent((Component)nameLabel, 1, 0);
        HorizontalLayout propertiesLayout = new HorizontalLayout();
        propertiesLayout.setSpacing(true);
        details.addComponent((Component)propertiesLayout);
        String versionString = this.i18nManager.getMessage("process.version", new Object[]{this.processDefinition.getVersion()});
        Label versionLabel = new Label(versionString);
        versionLabel.addStyleName("process-version");
        propertiesLayout.addComponent((Component)versionLabel);
        PrettyTimeLabel deployTimeLabel = new PrettyTimeLabel(this.i18nManager.getMessage("process.deploy.time"), this.deployment.getDeploymentTime(), null, true);
        deployTimeLabel.addStyleName("process-deploy-time");
        propertiesLayout.addComponent((Component)deployTimeLabel);
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName();
        }
        return processDefinition.getKey();
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }
}

