/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.Application;
import com.vaadin.terminal.StreamResource;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.diagram.ProcessDiagramGenerator;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.util.InputStreamStreamSource;

public class ProcessDefinitionImageStreamResourceBuilder {
    public StreamResource buildStreamResource(ProcessDefinition processDefinition, RepositoryService repositoryService) {
        StreamResource imageResource = null;
        if (processDefinition.getDiagramResourceName() != null) {
            InputStream definitionImageStream = repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getDiagramResourceName());
            InputStreamStreamSource streamSource = new InputStreamStreamSource(definitionImageStream);
            String imageExtension = this.extractImageExtension(processDefinition.getDiagramResourceName());
            String fileName = processDefinition.getId() + "." + imageExtension;
            imageResource = new StreamResource((StreamResource.StreamSource)streamSource, fileName, (Application)ExplorerApp.get());
        }
        return imageResource;
    }

    public StreamResource buildStreamResource(ProcessInstance processInstance, RepositoryService repositoryService, RuntimeService runtimeService) {
        StreamResource imageResource = null;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        if (processDefinition != null && processDefinition.isGraphicalNotationDefined()) {
            InputStream definitionImageStream = ProcessDiagramGenerator.generateDiagram((ProcessDefinitionEntity)processDefinition, (String)"png", (List)runtimeService.getActiveActivityIds(processInstance.getId()));
            InputStreamStreamSource streamSource = new InputStreamStreamSource(definitionImageStream);
            String imageExtension = this.extractImageExtension(processDefinition.getDiagramResourceName());
            String fileName = processInstance.getId() + UUID.randomUUID() + "." + imageExtension;
            imageResource = new StreamResource((StreamResource.StreamSource)streamSource, fileName, (Application)ExplorerApp.get());
        }
        return imageResource;
    }

    protected String extractImageExtension(String diagramResourceName) {
        String[] parts = diagramResourceName.split(".");
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return "png";
    }
}

