/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.process.ProcessDefinitionImageStreamResourceBuilder;

public class ProcessDefinitionInfoComponent
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ProcessDefinition processDefinition;
    protected Deployment deployment;
    protected HorizontalLayout timeDetails;
    protected VerticalLayout processImageContainer;

    public ProcessDefinitionInfoComponent(ProcessDefinition processDefinition, Deployment deployment) {
        this.processDefinition = processDefinition;
        this.deployment = deployment;
        this.addStyleName("block-holder");
        this.initImage();
    }

    protected void initImage() {
        this.processImageContainer = new VerticalLayout();
        Label processTitle = new Label(this.i18nManager.getMessage("process.header.diagram"));
        processTitle.addStyleName("h3");
        this.processImageContainer.addComponent((Component)processTitle);
        if (this.processDefinition.getDiagramResourceName() != null) {
            StreamResource diagram = new ProcessDefinitionImageStreamResourceBuilder().buildStreamResource(this.processDefinition, this.repositoryService);
            Embedded embedded = new Embedded(null, (Resource)diagram);
            embedded.setType(1);
            embedded.setSizeUndefined();
            Panel imagePanel = new Panel();
            imagePanel.addStyleName("light");
            imagePanel.setWidth(100.0f, 8);
            imagePanel.setHeight(400.0f, 0);
            HorizontalLayout panelLayout = new HorizontalLayout();
            panelLayout.setSizeUndefined();
            imagePanel.setContent((ComponentContainer)panelLayout);
            imagePanel.addComponent((Component)embedded);
            this.processImageContainer.addComponent((Component)imagePanel);
        } else {
            Label noImageAvailable = new Label(this.i18nManager.getMessage("process.no.diagram"));
            this.processImageContainer.addComponent((Component)noImageAvailable);
        }
        this.addComponent((Component)this.processImageContainer);
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }
}

