/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.process.ProcessDefinitionListQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionListQuery
extends AbstractLazyLoadingQuery {
    protected RepositoryService repositoryService;

    public ProcessDefinitionListQuery(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public List<Item> loadItems(int start, int count) {
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionName().asc()).orderByProcessDefinitionKey().asc()).listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            items.add((Item)this.createItem(processDefinition));
        }
        return items;
    }

    public Item loadSingleResult(String id) {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (definition != null) {
            return this.createItem(definition);
        }
        return null;
    }

    protected ProcessDefinitionListItem createItem(ProcessDefinition processDefinition) {
        ProcessDefinitionListItem item = new ProcessDefinitionListItem(this);
        item.addItemProperty((Object)"id", (Property)new ObjectProperty((Object)processDefinition.getId(), String.class));
        item.addItemProperty((Object)"name", (Property)new ObjectProperty((Object)this.getProcessDisplayName(processDefinition), String.class));
        item.addItemProperty((Object)"key", (Property)new ObjectProperty((Object)processDefinition.getKey(), String.class));
        return item;
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName();
        }
        return processDefinition.getKey();
    }

    public int size() {
        return (int)this.repositoryService.createProcessDefinitionQuery().latestVersion().count();
    }

    public void setSorting(Object[] propertyId, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }
}

