/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.profile;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Form;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.TabbedSelectionWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountSelectionPopup
extends TabbedSelectionWindow {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected Form imapForm;
    protected Button.ClickListener imapClickListener;
    protected Form alfrescoForm;
    protected Button.ClickListener alfrescoClickListener;

    public AccountSelectionPopup(String title) {
        super(title);
        this.setWidth(600.0f, 0);
        this.setHeight(400.0f, 0);
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.initImapComponent();
        String imap = this.i18nManager.getMessage("profile.account.imap");
        this.addSelectionItem(new Embedded(null, Images.IMAP), imap, (Component)this.imapForm, this.imapClickListener);
        this.initAlfrescoComponent();
        this.addSelectionItem(new Embedded(null, Images.ALFRESCO), this.i18nManager.getMessage("profile.account.alfresco"), (Component)this.alfrescoForm, this.alfrescoClickListener);
        this.selectionTable.select((Object)imap);
    }

    protected void initImapComponent() {
        this.imapForm = new Form();
        this.imapForm.setDescription(this.i18nManager.getMessage("imap.description"));
        TextField imapServer = new TextField(this.i18nManager.getMessage("imap.server"));
        this.imapForm.getLayout().addComponent((Component)imapServer);
        TextField imapPort = new TextField(this.i18nManager.getMessage("imap.port"));
        imapPort.setWidth(30.0f, 0);
        imapPort.setValue((Object)143);
        this.imapForm.getLayout().addComponent((Component)imapPort);
        CheckBox useSSL = new CheckBox(this.i18nManager.getMessage("imap.ssl"));
        useSSL.setValue((Object)false);
        useSSL.setImmediate(true);
        this.imapForm.getLayout().addComponent((Component)useSSL);
        useSSL.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        TextField imapUserName = new TextField(this.i18nManager.getMessage("imap.username"));
        this.imapForm.getLayout().addComponent((Component)imapUserName);
        PasswordField imapPassword = new PasswordField(this.i18nManager.getMessage("imap.password"));
        this.imapForm.getLayout().addComponent((Component)imapPassword);
        this.imapClickListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void initAlfrescoComponent() {
        this.alfrescoForm = new Form();
        this.alfrescoForm.setDescription(this.i18nManager.getMessage("alfresco.description"));
        TextField alfrescoServer = new TextField(this.i18nManager.getMessage("alfresco.server"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoServer);
        TextField alfrescoUserName = new TextField(this.i18nManager.getMessage("alfresco.username"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoUserName);
        PasswordField alfrescoPassword = new PasswordField(this.i18nManager.getMessage("alfresco.password"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoPassword);
        this.alfrescoClickListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Map<String, Object> createAccountDetails(String acountName, String userName, String password, String ... additionalDetails) {
        HashMap<String, Object> accountDetails = new HashMap<String, Object>();
        accountDetails.put("accountName", acountName);
        accountDetails.put("userName", userName);
        accountDetails.put("password", password);
        if (additionalDetails != null && additionalDetails.length > 0) {
            HashMap<String, String> additional = new HashMap<String, String>();
            for (int i = 0; i < additionalDetails.length; i += 2) {
                additional.put(additionalDetails[i], additionalDetails[i + 1]);
            }
            accountDetails.put("additional", additional);
        }
        return accountDetails;
    }

    static /* synthetic */ void access$000(AccountSelectionPopup x0, Component.Event x1) {
        x0.fireEvent(x1);
    }

    static /* synthetic */ void access$100(AccountSelectionPopup x0, Component.Event x1) {
        x0.fireEvent(x1);
    }
}

