/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.data.Property;
import com.vaadin.event.LayoutEvents;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.DateField;
import com.vaadin.ui.Label;
import java.util.Date;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;

public class DueDateComponent
extends CssLayout {
    private static final long serialVersionUID = 1L;
    protected Task task;
    protected I18nManager i18nManager;
    protected TaskService taskService;
    protected Label dueDateLabel;
    protected DateField dueDateField;

    public DueDateComponent(Task task, I18nManager i18nManager, TaskService taskService) {
        this.task = task;
        this.i18nManager = i18nManager;
        this.taskService = taskService;
        this.setSizeUndefined();
        this.initDueDateLabel();
        this.initDueDateField();
        this.initLayoutClickListener();
        this.initDueDateFieldListener();
    }

    protected void initDueDateLabel() {
        this.dueDateLabel = new PrettyTimeLabel(this.i18nManager.getMessage("task.duedate.short"), this.task.getDueDate(), this.i18nManager.getMessage("task.duedate.unknown"), false);
        this.dueDateLabel.addStyleName("task-duedate");
        this.dueDateLabel.setSizeUndefined();
        this.dueDateLabel.addStyleName("clickable");
        this.addComponent((Component)this.dueDateLabel);
    }

    protected void initDueDateField() {
        this.dueDateField = new DateField();
        if (this.task.getDueDate() != null) {
            this.dueDateField.setValue((Object)this.task.getDueDate());
        } else {
            this.dueDateField.setValue((Object)new Date());
        }
        this.dueDateField.setWidth(125.0f, 0);
        this.dueDateField.setResolution(4);
        this.dueDateField.setImmediate(true);
    }

    protected void initLayoutClickListener() {
        this.addListener((LayoutEvents.LayoutClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initDueDateFieldListener() {
        this.dueDateField.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

