/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.event.Action;
import com.vaadin.event.MouseEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.task.TaskDetailPanel;
import org.activiti.explorer.ui.task.listener.DeleteSubTaskClickListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTaskComponent
extends CustomComponent {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected Task parentTask;
    protected TaskDetailPanel taskDetailPanel;
    protected VerticalLayout layout;
    protected Label title;
    protected Panel addSubTaskPanel;
    protected Button addSubTaskButton;
    protected TextField newTaskTextField;
    protected GridLayout subTaskLayout;

    public SubTaskComponent(Task parentTask) {
        this.parentTask = parentTask;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
        this.initUi();
    }

    protected void initUi() {
        this.addStyleName("block-holder");
        this.addStyleName("involve-people");
        this.initLayout();
        this.initHeader();
        this.initSubTasks();
    }

    protected void initLayout() {
        this.layout = new VerticalLayout();
        this.setCompositionRoot((Component)this.layout);
    }

    protected void initHeader() {
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.setWidth(100.0f, 8);
        this.layout.addComponent((Component)headerLayout);
        this.initTitle(headerLayout);
        this.initAddSubTaskPanel(headerLayout);
    }

    protected void initTitle(HorizontalLayout headerLayout) {
        this.title = new Label(this.i18nManager.getMessage("task.subtasks"));
        this.title.addStyleName("h3");
        this.title.setWidth(100.0f, 8);
        headerLayout.addComponent((Component)this.title);
        headerLayout.setExpandRatio((Component)this.title, 1.0f);
    }

    protected void initAddSubTaskPanel(HorizontalLayout headerLayout) {
        this.addSubTaskPanel = new Panel();
        this.addSubTaskPanel.setContent((ComponentContainer)new VerticalLayout());
        this.addSubTaskPanel.setSizeUndefined();
        this.addSubTaskPanel.addStyleName("light");
        this.addSubTaskPanel.addStyleName("no-border");
        headerLayout.addComponent((Component)this.addSubTaskPanel);
        this.initAddSubTaskPanelKeyboardActions();
        this.initAddButton();
    }

    protected void initAddSubTaskPanelKeyboardActions() {
        this.addSubTaskPanel.addActionHandler((Action.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initAddButton() {
        this.addSubTaskButton = new Button();
        this.addSubTaskButton.addStyleName("add");
        this.addSubTaskPanel.addComponent((Component)this.addSubTaskButton);
        this.addSubTaskButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void resetAddButton() {
        this.addSubTaskPanel.removeAllComponents();
        this.initAddButton();
    }

    protected void initSubTasks() {
        List subTasks = this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(this.parentTask.getId()).list();
        this.initSubTasksLayout();
        this.populateSubTasks(subTasks);
    }

    protected void initSubTasksLayout() {
        this.subTaskLayout = new GridLayout();
        this.subTaskLayout.setColumns(3);
        this.subTaskLayout.addStyleName("subtasks");
        this.subTaskLayout.setWidth(99.0f, 8);
        this.subTaskLayout.setColumnExpandRatio(2, 1.0f);
        this.subTaskLayout.setSpacing(true);
        this.layout.addComponent((Component)this.subTaskLayout);
    }

    protected void populateSubTasks(List<HistoricTaskInstance> subTasks) {
        if (subTasks.size() > 0) {
            for (HistoricTaskInstance subTask : subTasks) {
                Embedded icon = null;
                icon = subTask.getEndTime() != null ? new Embedded(null, Images.TASK_FINISHED_22) : new Embedded(null, Images.TASK_22);
                icon.setWidth(22.0f, 0);
                icon.setWidth(22.0f, 0);
                this.subTaskLayout.addComponent((Component)icon);
                Button subTaskLink = new Button(subTask.getName());
                subTaskLink.addStyleName("link");
                subTaskLink.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                this.subTaskLayout.addComponent((Component)subTaskLink);
                this.subTaskLayout.setComponentAlignment((Component)subTaskLink, Alignment.MIDDLE_LEFT);
                if (subTask.getEndTime() == null) {
                    Embedded deleteIcon = new Embedded(null, Images.DELETE);
                    deleteIcon.addStyleName("clickable");
                    deleteIcon.addListener((MouseEvents.ClickListener)new DeleteSubTaskClickListener(subTask, this));
                    this.subTaskLayout.addComponent((Component)deleteIcon);
                    this.subTaskLayout.setComponentAlignment((Component)deleteIcon, Alignment.MIDDLE_RIGHT);
                    continue;
                }
                this.subTaskLayout.newLine();
            }
        } else {
            Label noSubTasksLabel = new Label(this.i18nManager.getMessage("task.no.subtasks"));
            noSubTasksLabel.setSizeUndefined();
            noSubTasksLabel.addStyleName("light");
            this.subTaskLayout.addComponent((Component)noSubTasksLabel);
        }
    }

    public void refreshSubTasks() {
        this.subTaskLayout.removeAllComponents();
        List subTasks = this.historyService.createHistoricTaskInstanceQuery().taskParentTaskId(this.parentTask.getId()).list();
        this.populateSubTasks(subTasks);
    }
}

