/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.ui.Label;
import org.activiti.engine.identity.User;
import org.activiti.engine.task.Event;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.cache.UserCache;

public class TaskEventTextResolver {
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected UserCache userCache = ExplorerApp.get().getUserCache();

    public Label resolveText(Event event) {
        User user = this.userCache.findUser(event.getUserId());
        String eventAuthor = "<span class='task-event-author'>" + user.getFirstName() + " " + user.getLastName() + "</span> ";
        String text = null;
        if ("AddUserLink".equals(event.getAction())) {
            User involvedUser = this.userCache.findUser((String)event.getMessageParts().get(0));
            text = this.i18nManager.getMessage("event.add.user.link", new Object[]{eventAuthor, involvedUser.getFirstName() + " " + involvedUser.getLastName(), event.getMessageParts().get(1)});
        } else if ("DeleteUserLink".equals(event.getAction())) {
            User involvedUser = this.userCache.findUser((String)event.getMessageParts().get(0));
            text = this.i18nManager.getMessage("event.delete.user.link", new Object[]{eventAuthor, involvedUser.getFirstName() + " " + involvedUser.getLastName(), event.getMessageParts().get(1)});
        } else {
            text = "AddGroupLink".equals(event.getAction()) ? this.i18nManager.getMessage("event.add.group.link", new Object[]{eventAuthor, event.getMessageParts().get(0), event.getMessageParts().get(1)}) : ("DeleteGroupLink".equals(event.getAction()) ? this.i18nManager.getMessage("event.delete.group.link", new Object[]{eventAuthor, event.getMessageParts().get(0), event.getMessageParts().get(1)}) : ("AddAttachment".equals(event.getAction()) ? this.i18nManager.getMessage("event.add.attachment", new Object[]{eventAuthor, event.getMessage()}) : ("DeleteAttachment".equals(event.getAction()) ? this.i18nManager.getMessage("event.delete.attachment", new Object[]{eventAuthor, event.getMessage()}) : ("AddComment".equals(event.getAction()) ? this.i18nManager.getMessage("event.comment", new Object[]{eventAuthor, event.getMessage()}) : text + this.i18nManager.getMessage("event.default", new Object[]{eventAuthor, event.getMessage()})))));
        }
        return new Label(text, 3);
    }
}

