/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.task.TaskDetailPanel;
import org.activiti.explorer.ui.task.UserDetailsComponent;
import org.activiti.explorer.ui.task.listener.ChangeOwnershipListener;
import org.activiti.explorer.ui.task.listener.ReassignAssigneeListener;
import org.activiti.explorer.ui.task.listener.RemoveInvolvedPersonListener;

public class TaskInvolvedPeopleComponent
extends CustomComponent {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected ViewManager viewManager;
    protected TaskService taskService;
    protected Task task;
    protected TaskDetailPanel taskDetailPanel;
    protected VerticalLayout layout;
    protected Label title;
    protected Button addPeopleButton;
    protected GridLayout peopleGrid;

    public TaskInvolvedPeopleComponent(Task task, TaskDetailPanel taskDetailPanel) {
        this.task = task;
        this.taskDetailPanel = taskDetailPanel;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.viewManager = ExplorerApp.get().getViewManager();
        this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        this.initUi();
    }

    protected void initUi() {
        this.addStyleName("block-holder");
        this.addStyleName("involve-people");
        this.initLayout();
        this.initHeader();
        this.initPeopleGrid();
    }

    protected void initLayout() {
        this.layout = new VerticalLayout();
        this.setCompositionRoot((Component)this.layout);
    }

    protected void initHeader() {
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.setWidth(100.0f, 8);
        this.layout.addComponent((Component)headerLayout);
        this.initTitle(headerLayout);
        this.initAddPeopleButton(headerLayout);
    }

    protected void initTitle(HorizontalLayout headerLayout) {
        this.title = new Label(this.i18nManager.getMessage("task.people"));
        this.title.addStyleName("h3");
        this.title.setWidth(100.0f, 8);
        headerLayout.addComponent((Component)this.title);
        headerLayout.setExpandRatio((Component)this.title, 1.0f);
    }

    protected void initAddPeopleButton(HorizontalLayout headerLayout) {
        this.addPeopleButton = new Button();
        this.addPeopleButton.addStyleName("add");
        headerLayout.addComponent((Component)this.addPeopleButton);
        this.addPeopleButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initPeopleGrid() {
        this.peopleGrid = new GridLayout();
        this.peopleGrid.setColumns(2);
        this.peopleGrid.setSpacing(true);
        this.peopleGrid.setMargin(true, false, false, false);
        this.peopleGrid.setWidth(100.0f, 8);
        this.layout.addComponent((Component)this.peopleGrid);
        this.populatePeopleGrid();
    }

    protected void populatePeopleGrid() {
        this.initOwner();
        this.initAssignee();
        this.initInvolvedPeople();
    }

    protected void initOwner() {
        UserDetailsComponent ownerDetails = this.createOwnerComponent();
        this.peopleGrid.addComponent((Component)ownerDetails);
    }

    protected UserDetailsComponent createOwnerComponent() {
        String roleMessage = this.task.getOwner() != null ? "task.owner" : "task.no.owner";
        return new UserDetailsComponent(this.task.getOwner(), this.i18nManager.getMessage(roleMessage), this.i18nManager.getMessage("task.owner.transfer"), (Button.ClickListener)new ChangeOwnershipListener(this.task, this.taskDetailPanel));
    }

    protected void initAssignee() {
        UserDetailsComponent assigneeDetails = this.createAssigneeComponent();
        this.peopleGrid.addComponent((Component)assigneeDetails);
    }

    protected UserDetailsComponent createAssigneeComponent() {
        String roleMessage = this.task.getAssignee() != null ? "task.assignee" : "task.no.assignee";
        return new UserDetailsComponent(this.task.getAssignee(), this.i18nManager.getMessage(roleMessage), this.i18nManager.getMessage("task.assignee.reassign"), (Button.ClickListener)new ReassignAssigneeListener(this.task, this.taskDetailPanel));
    }

    protected void initInvolvedPeople() {
        List identityLinks = this.taskService.getIdentityLinksForTask(this.task.getId());
        for (IdentityLink identityLink : identityLinks) {
            if (identityLink.getUserId() == null || "assignee".equals(identityLink.getType())) continue;
            UserDetailsComponent involvedDetails = new UserDetailsComponent(identityLink.getUserId(), identityLink.getType(), this.i18nManager.getMessage("task.involved.remove"), (Button.ClickListener)new RemoveInvolvedPersonListener(identityLink, this.task, this.taskDetailPanel));
            this.peopleGrid.addComponent((Component)involvedDetails);
        }
    }

    public void refreshPeopleGrid() {
        this.task = (Task)this.taskService.createTaskQuery().taskId(this.task.getId()).singleResult();
        this.peopleGrid.removeAllComponents();
        this.populatePeopleGrid();
    }

    public void refreshAssignee() {
        this.task = (Task)this.taskService.createTaskQuery().taskId(this.task.getId()).singleResult();
        this.peopleGrid.removeComponent(1, 0);
        this.peopleGrid.addComponent((Component)this.createAssigneeComponent(), 1, 0);
    }

    public void refreshOwner() {
        this.task = (Task)this.taskService.createTaskQuery().taskId(this.task.getId()).singleResult();
        this.peopleGrid.removeComponent(0, 0);
        this.peopleGrid.addComponent((Component)this.createOwnerComponent(), 0, 0);
    }
}

