/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task.data;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.task.data.TaskListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskListQuery
extends AbstractLazyLoadingQuery {
    protected String userId = ExplorerApp.get().getLoggedInUser().getId();
    protected TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();

    public int size() {
        return (int)this.getQuery().count();
    }

    public List<Item> loadItems(int start, int count) {
        List tasks = this.getQuery().listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (Task task : tasks) {
            items.add((Item)new TaskListItem(task));
        }
        return items;
    }

    public Item loadSingleResult(String id) {
        Task task = (Task)this.getQuery().taskId(id).singleResult();
        if (task != null) {
            return new TaskListItem(task);
        }
        return null;
    }

    public void setSorting(Object[] propertyId, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    protected abstract TaskQuery getQuery();
}

