/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task.data;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.task.data.TaskListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivedListQuery
extends AbstractLazyLoadingQuery {
    protected String userId = ExplorerApp.get().getLoggedInUser().getId();
    protected HistoryService historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();

    public int size() {
        return (int)this.createQuery().count();
    }

    public List<Item> loadItems(int start, int count) {
        List historicTaskInstances = this.createQuery().listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            items.add((Item)new TaskListItem(historicTaskInstance));
        }
        return items;
    }

    public Item loadSingleResult(String id) {
        return new TaskListItem((HistoricTaskInstance)this.createQuery().taskId(id).singleResult());
    }

    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    protected HistoricTaskInstanceQuery createQuery() {
        return this.historyService.createHistoricTaskInstanceQuery().taskOwner(this.userId).finished();
    }
}

