/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.util;

import com.thebuzzmedia.imgscalr.Scalr;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.activiti.explorer.Constants;

public class ImageUtil {
    protected static final Logger LOGGER = Logger.getLogger(ImageUtil.class.getName());

    public static InputStream smallify(InputStream imageInputStream, String mimeType, int maxWidth, int maxHeight) {
        try {
            BufferedImage image = ImageIO.read(imageInputStream);
            int width = Math.min(image.getWidth(), maxWidth);
            int height = Math.min(image.getHeight(), maxHeight);
            Scalr.Mode mode = Scalr.Mode.AUTOMATIC;
            if (image.getHeight() > maxHeight) {
                mode = Scalr.Mode.FIT_TO_HEIGHT;
            }
            if (width != image.getWidth() || height != image.getHeight()) {
                image = Scalr.resize((BufferedImage)image, (Scalr.Mode)mode, (int)width, (int)height);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, (String)Constants.MIMETYPE_EXTENSION_MAPPING.get(mimeType), bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception while resizing image", e);
            return null;
        }
    }
}

