/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UriUtility {
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String QUERY_STRING_SEPARATOR = "?";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String URL_PART_SEPARATOR = "/";

    public static List<String> getFragmentParts(String url) {
        if (url != null) {
            String[] partsArray;
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : partsArray = url.split("/")) {
                if (part.length() <= 0) continue;
                parts.add(part);
            }
            return parts;
        }
        return null;
    }

    public static String extractQueryString(String fragment) {
        int firstIndex;
        if (fragment != null && (firstIndex = fragment.indexOf("?")) >= 0) {
            return fragment.substring(firstIndex);
        }
        return null;
    }

    public static String extractUri(String fragment) {
        if (fragment != null) {
            int firstIndex = fragment.indexOf("?");
            if (firstIndex >= 0) {
                return fragment.substring(0, firstIndex);
            }
            return fragment;
        }
        return null;
    }

    public static Map<String, String> parseQueryParameters(String queryString, String encoding) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (queryString != null) {
            if (queryString.startsWith("?")) {
                queryString = queryString.substring(1);
            }
            Scanner scanner = new Scanner(queryString);
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                String[] nameValue = scanner.next().split("=");
                if (nameValue.length == 0 || nameValue.length > 2) {
                    throw new IllegalArgumentException("bad parameter");
                }
                String name = UriUtility.decode((String)nameValue[0], (String)encoding);
                String value = null;
                if (nameValue.length == 2) {
                    value = UriUtility.decode((String)nameValue[1], (String)encoding);
                }
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    public static String getQueryString(Map<String, String> parameters) {
        StringBuilder result = new StringBuilder();
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                String encodedValue;
                String encodedName = UriUtility.encode((String)param.getKey(), null);
                String value = param.getValue();
                String string = encodedValue = value != null ? UriUtility.encode((String)value, null) : "";
                if (result.length() > 0) {
                    result.append("&");
                } else {
                    result.append("?");
                }
                result.append(encodedName);
                result.append("=");
                result.append(encodedValue);
            }
        }
        return result.toString();
    }

    public static String getPath(List<String> parts) {
        if (parts != null) {
            StringBuilder result = new StringBuilder();
            for (String part : parts) {
                if (result.length() > 0) {
                    result.append("/");
                }
                result.append(part);
            }
            return result.toString();
        }
        return "";
    }

    private static String decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

