/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.util.time;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.util.time.TimeUnit;
import org.activiti.explorer.util.time.timeunit.DayTimeUnit;
import org.activiti.explorer.util.time.timeunit.HourTimeUnit;
import org.activiti.explorer.util.time.timeunit.MinuteTimeUnit;
import org.activiti.explorer.util.time.timeunit.MonthTimeUnit;
import org.activiti.explorer.util.time.timeunit.WeekTimeUnit;
import org.activiti.explorer.util.time.timeunit.YearTimeUnit;

public class HumanTime {
    private static final List<TimeUnit> timeUnits = Arrays.asList(new YearTimeUnit(), new MonthTimeUnit(), new WeekTimeUnit(), new DayTimeUnit(), new HourTimeUnit(), new MinuteTimeUnit());
    private Long baseDate;
    private I18nManager i18nManager;

    public HumanTime(I18nManager i18nManager) {
        this(null, i18nManager);
    }

    public HumanTime(Date date, I18nManager i18nManager) {
        if (i18nManager == null) {
            throw new IllegalArgumentException("I18NManager is required!");
        }
        this.i18nManager = i18nManager;
        this.baseDate = date != null ? Long.valueOf(date.getTime()) : Long.valueOf(new Date().getTime());
    }

    public String format(Date date) {
        boolean future = true;
        Long difference = date.getTime() - this.baseDate;
        if (difference < 0L) {
            future = false;
            difference = -difference.longValue();
        } else if (difference == 0L) {
            return this.i18nManager.getMessage("time.unit.just.now");
        }
        String unitMessage = this.getUnitMessage(difference);
        String messageKey = null;
        messageKey = future ? "time.unit.future" : "time.unit.past";
        return this.i18nManager.getMessage(messageKey, new Object[]{unitMessage});
    }

    private String getUnitMessage(Long difference) {
        String unitMessage = null;
        TimeUnit unitToUse = null;
        TimeUnit currentUnit = null;
        for (int i = 0; i < timeUnits.size() && unitToUse == null; ++i) {
            currentUnit = (TimeUnit)timeUnits.get(i);
            if (currentUnit.getNumberOfMillis() > difference) continue;
            unitToUse = currentUnit;
        }
        if (unitToUse == null) {
            unitMessage = this.i18nManager.getMessage("time.unit.moments");
        } else {
            Long numberOfUnits = (difference - difference % unitToUse.getNumberOfMillis()) / unitToUse.getNumberOfMillis();
            unitMessage = this.i18nManager.getMessage(unitToUse.getMessageKey(numberOfUnits), new Object[]{numberOfUnits});
        }
        return unitMessage;
    }
}

