/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Point;

public class Point3 {
    public double x;
    public double y;
    public double z;

    public Point3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Point3() {
        this(0.0, 0.0, 0.0);
    }

    public Point3(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = 0.0;
    }

    public Point3(double[] dArray) {
        this();
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.x = dArray.length > 0 ? dArray[0] : 0.0;
            this.y = dArray.length > 1 ? dArray[1] : 0.0;
            this.z = dArray.length > 2 ? dArray[2] : 0.0;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
    }

    public Point3 clone() {
        return new Point3(this.x, this.y, this.z);
    }

    public double dot(Point3 point3) {
        return this.x * point3.x + this.y * point3.y + this.z * point3.z;
    }

    public Point3 cross(Point3 point3) {
        return new Point3(this.y * point3.z - this.z * point3.y, this.z * point3.x - this.x * point3.z, this.x * point3.y - this.y * point3.x);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Point3)) {
            return false;
        }
        Point3 point3 = (Point3)object;
        return this.x == point3.x && this.y == point3.y && this.z == point3.z;
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }
}

