/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfDouble
extends Mat {
    private static final int _depth = 6;
    private static final int _channels = 1;

    public MatOfDouble() {
    }

    protected MatOfDouble(long l) {
        super(l);
        if (!this.empty() && this.checkVector(1, 6) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfDouble fromNativeAddr(long l) {
        return new MatOfDouble(l);
    }

    public MatOfDouble(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(1, 6) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfDouble(double ... dArray) {
        this.fromArray(dArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(6, 1));
        }
    }

    public void fromArray(double ... dArray) {
        if (dArray == null || dArray.length == 0) {
            return;
        }
        int n = dArray.length / 1;
        this.alloc(n);
        this.put(0, 0, dArray);
    }

    public double[] toArray() {
        int n = this.checkVector(1, 6);
        if (n < 0) {
            throw new RuntimeException("Native Mat has unexpected type or size: " + this.toString());
        }
        double[] dArray = new double[n * 1];
        if (n == 0) {
            return dArray;
        }
        this.get(0, 0, dArray);
        return dArray;
    }

    public void fromList(List<Double> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Double[] doubleArray = list.toArray(new Double[0]);
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        this.fromArray(dArray);
    }

    public List<Double> toList() {
        double[] dArray = this.toArray();
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return Arrays.asList(doubleArray);
    }
}

