/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfFloat4
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 4;

    public MatOfFloat4() {
    }

    protected MatOfFloat4(long l) {
        super(l);
        if (!this.empty() && this.checkVector(4, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfFloat4 fromNativeAddr(long l) {
        return new MatOfFloat4(l);
    }

    public MatOfFloat4(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(4, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfFloat4(float ... fArray) {
        this.fromArray(fArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 4));
        }
    }

    public void fromArray(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return;
        }
        int n = fArray.length / 4;
        this.alloc(n);
        this.put(0, 0, fArray);
    }

    public float[] toArray() {
        int n = this.checkVector(4, 5);
        if (n < 0) {
            throw new RuntimeException("Native Mat has unexpected type or size: " + this.toString());
        }
        float[] fArray = new float[n * 4];
        if (n == 0) {
            return fArray;
        }
        this.get(0, 0, fArray);
        return fArray;
    }

    public void fromList(List<Float> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Float[] floatArray = list.toArray(new Float[0]);
        float[] fArray = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        this.fromArray(fArray);
    }

    public List<Float> toList() {
        float[] fArray = this.toArray();
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return Arrays.asList(floatArray);
    }
}

