/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;

public class Scalar {
    public double[] val;

    public Scalar(double d, double d2, double d3, double d4) {
        this.val = new double[]{d, d2, d3, d4};
    }

    public Scalar(double d, double d2, double d3) {
        this.val = new double[]{d, d2, d3, 0.0};
    }

    public Scalar(double d, double d2) {
        this.val = new double[]{d, d2, 0.0, 0.0};
    }

    public Scalar(double d) {
        this.val = new double[]{d, 0.0, 0.0, 0.0};
    }

    public Scalar(double[] dArray) {
        if (dArray != null && dArray.length == 4) {
            this.val = (double[])dArray.clone();
        } else {
            this.val = new double[4];
            this.set(dArray);
        }
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.val[0] = dArray.length > 0 ? dArray[0] : 0.0;
            this.val[1] = dArray.length > 1 ? dArray[1] : 0.0;
            this.val[2] = dArray.length > 2 ? dArray[2] : 0.0;
            this.val[3] = dArray.length > 3 ? dArray[3] : 0.0;
        } else {
            this.val[3] = 0.0;
            this.val[2] = 0.0;
            this.val[1] = 0.0;
            this.val[0] = 0.0;
        }
    }

    public static Scalar all(double d) {
        return new Scalar(d, d, d, d);
    }

    public Scalar clone() {
        return new Scalar(this.val);
    }

    public Scalar mul(Scalar scalar, double d) {
        return new Scalar(this.val[0] * scalar.val[0] * d, this.val[1] * scalar.val[1] * d, this.val[2] * scalar.val[2] * d, this.val[3] * scalar.val[3] * d);
    }

    public Scalar mul(Scalar scalar) {
        return this.mul(scalar, 1.0);
    }

    public Scalar conj() {
        return new Scalar(this.val[0], -this.val[1], -this.val[2], -this.val[3]);
    }

    public boolean isReal() {
        return this.val[1] == 0.0 && this.val[2] == 0.0 && this.val[3] == 0.0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.val);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scalar)) {
            return false;
        }
        Scalar scalar = (Scalar)object;
        return Arrays.equals(this.val, scalar.val);
    }

    public String toString() {
        return "[" + this.val[0] + ", " + this.val[1] + ", " + this.val[2] + ", " + this.val[3] + "]";
    }
}

